/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiMuonNeutrino;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.Muon;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class MuonNeutrino
extends Lepton {
    @Override
    public double restMass() {
        return 0.0;
    }

    @Override
    public int charge() {
        return 0;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return 1;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new AntiMuonNeutrino();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof AntiMuonNeutrino;
    }

    public String toString() {
        return new String("Muon neutrino");
    }

    public Muon emit(WPlus w) {
        Muon e = new Muon();
        e.momentum = this.momentum.subtract(w.momentum);
        return e;
    }

    public Muon absorb(WMinus w) {
        Muon e = new Muon();
        e.momentum = this.momentum.add(w.momentum);
        return e;
    }

    public MuonNeutrino emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public MuonNeutrino absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

