/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiMuon;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.MuonNeutrino;
import jsci.physics.particles.Photon;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class Muon
extends Lepton {
    @Override
    public double restMass() {
        return 105.658357;
    }

    @Override
    public int charge() {
        return -1;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return 1;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new AntiMuon();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof AntiMuon;
    }

    public String toString() {
        return new String("Muon");
    }

    public Muon emit(Photon y) {
        this.momentum = this.momentum.subtract(y.momentum);
        return this;
    }

    public Muon absorb(Photon y) {
        this.momentum = this.momentum.add(y.momentum);
        return this;
    }

    public MuonNeutrino emit(WMinus w) {
        MuonNeutrino n = new MuonNeutrino();
        n.momentum = this.momentum.subtract(w.momentum);
        return n;
    }

    public MuonNeutrino emit(WPlus w) {
        MuonNeutrino n = new MuonNeutrino();
        n.momentum = this.momentum.add(w.momentum);
        return n;
    }

    public Muon emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public Muon absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

