/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.ElectronNeutrino;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.Photon;
import jsci.physics.particles.Positron;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class Electron
extends Lepton {
    @Override
    public double restMass() {
        return 0.510998902;
    }

    @Override
    public int charge() {
        return -1;
    }

    @Override
    public int eLeptonQN() {
        return 1;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new Positron();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof Positron;
    }

    public String toString() {
        return new String("Electron");
    }

    public Electron emit(Photon y) {
        this.momentum = this.momentum.subtract(y.momentum);
        return this;
    }

    public Electron absorb(Photon y) {
        this.momentum = this.momentum.add(y.momentum);
        return this;
    }

    public ElectronNeutrino emit(WMinus w) {
        ElectronNeutrino n = new ElectronNeutrino();
        n.momentum = this.momentum.subtract(w.momentum);
        return n;
    }

    public ElectronNeutrino absorb(WPlus w) {
        ElectronNeutrino n = new ElectronNeutrino();
        n.momentum = this.momentum.add(w.momentum);
        return n;
    }

    public Electron emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public Electron absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

