/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiLepton;
import jsci.physics.particles.AntiTauNeutrino;
import jsci.physics.particles.Photon;
import jsci.physics.particles.Tau;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class AntiTau
extends AntiLepton {
    @Override
    public double restMass() {
        return 1777.03;
    }

    @Override
    public int charge() {
        return 1;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return -1;
    }

    @Override
    public QuantumParticle anti() {
        return new Tau();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof Tau;
    }

    public String toString() {
        return new String("Antitau");
    }

    public AntiTau emit(Photon y) {
        this.momentum = this.momentum.subtract(y.momentum);
        return this;
    }

    public AntiTau absorb(Photon y) {
        this.momentum = this.momentum.add(y.momentum);
        return this;
    }

    public AntiTauNeutrino emit(WPlus w) {
        AntiTauNeutrino n = new AntiTauNeutrino();
        n.momentum = this.momentum.subtract(w.momentum);
        return n;
    }

    public AntiTauNeutrino absorb(WMinus w) {
        AntiTauNeutrino n = new AntiTauNeutrino();
        n.momentum = this.momentum.add(w.momentum);
        return n;
    }

    public AntiTau emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public AntiTau absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

