/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiLepton;
import jsci.physics.particles.AntiMuonNeutrino;
import jsci.physics.particles.Muon;
import jsci.physics.particles.Photon;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class AntiMuon
extends AntiLepton {
    @Override
    public double restMass() {
        return 105.658357;
    }

    @Override
    public int charge() {
        return 1;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return -1;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new Muon();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof Muon;
    }

    public String toString() {
        return new String("Antimuon");
    }

    public AntiMuon emit(Photon y) {
        this.momentum = this.momentum.subtract(y.momentum);
        return this;
    }

    public AntiMuon absorb(Photon y) {
        this.momentum = this.momentum.add(y.momentum);
        return this;
    }

    public AntiMuonNeutrino emit(WPlus w) {
        AntiMuonNeutrino n = new AntiMuonNeutrino();
        n.momentum = this.momentum.subtract(w.momentum);
        return n;
    }

    public AntiMuonNeutrino absorb(WMinus w) {
        AntiMuonNeutrino n = new AntiMuonNeutrino();
        n.momentum = this.momentum.add(w.momentum);
        return n;
    }

    public AntiMuon emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public AntiMuon absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

