/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiLepton;
import jsci.physics.particles.ElectronNeutrino;
import jsci.physics.particles.Positron;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class AntiElectronNeutrino
extends AntiLepton {
    @Override
    public double restMass() {
        return 0.0;
    }

    @Override
    public int charge() {
        return 0;
    }

    @Override
    public int eLeptonQN() {
        return -1;
    }

    @Override
    public int muLeptonQN() {
        return 0;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new ElectronNeutrino();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof ElectronNeutrino;
    }

    public String toString() {
        return new String("Antielectron neutrino");
    }

    public Positron emit(WMinus w) {
        Positron e = new Positron();
        e.momentum = this.momentum.subtract(w.momentum);
        return e;
    }

    public Positron absorb(WPlus w) {
        Positron e = new Positron();
        e.momentum = this.momentum.add(w.momentum);
        return e;
    }

    public AntiElectronNeutrino emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public AntiElectronNeutrino absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

