/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;
import jsci.physics.AbstractClassicalParticle;

public class Spring {
    private final double coefficient;
    private AbstractDoubleVector x;

    public Spring(double coeff) {
        this.coefficient = coeff;
    }

    public void setPosition(AbstractDoubleVector pos) {
        this.x = pos;
    }

    public AbstractDoubleVector getPosition() {
        return this.x;
    }

    public double energy(AbstractClassicalParticle p) {
        double rr = 0.0;
        AbstractDoubleVector ppos = p.getPosition();
        for (int i = 0; i < this.x.dimension(); ++i) {
            double dx = ppos.getComponent(i) - this.x.getComponent(i);
            rr += dx * dx;
        }
        return this.coefficient * rr / 2.0;
    }

    public Force createForce(AbstractClassicalParticle p) {
        return new Force(p);
    }

    private class Force
    extends jsci.physics.Force {
        private final AbstractClassicalParticle p;

        public Force(AbstractClassicalParticle p) {
            this.p = p;
        }

        @Override
        public AbstractDoubleVector getVector(double t) {
            AbstractDoubleVector ppos = this.p.getPosition();
            double[] vec = new double[Spring.this.x.dimension()];
            for (int i = 0; i < vec.length; ++i) {
                vec[i] = -Spring.this.coefficient * (ppos.getComponent(i) - Spring.this.x.getComponent(i));
            }
            return new DoubleVector(vec);
        }
    }
}

