/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.physics.ClassicalParticle3D;

public class RigidBody3D
extends ClassicalParticle3D {
    protected double angMass;
    protected double angx;
    protected double angy;
    protected double angz;
    protected double angxVel;
    protected double angyVel;
    protected double angzVel;

    public void setMomentOfInertia(double MoI) {
        this.angMass = MoI;
    }

    public double getMomentOfInertia() {
        return this.angMass;
    }

    public void setAngles(double angleX, double angleY, double angleZ) {
        this.angx = angleX;
        this.angy = angleY;
        this.angz = angleZ;
    }

    public double getXAngle() {
        return this.angx;
    }

    public double getYAngle() {
        return this.angy;
    }

    public double getZAngle() {
        return this.angz;
    }

    public void setAngularVelocity(double angleXVel, double angleYVel, double angleZVel) {
        this.angxVel = angleXVel;
        this.angyVel = angleYVel;
        this.angzVel = angleZVel;
    }

    public double getXAngularVelocity() {
        return this.angxVel;
    }

    public double getYAngularVelocity() {
        return this.angyVel;
    }

    public double getZAngularVelocity() {
        return this.angzVel;
    }

    public void setAngularMomentum(double angleXMom, double angleYMom, double angleZMom) {
        this.angxVel = angleXMom / this.angMass;
        this.angyVel = angleYMom / this.angMass;
        this.angzVel = angleZMom / this.angMass;
    }

    public double getXAngularMomentum() {
        return this.angMass * this.angxVel;
    }

    public double getYAngularMomentum() {
        return this.angMass * this.angyVel;
    }

    public double getZAngularMomentum() {
        return this.angMass * this.angzVel;
    }

    @Override
    public double energy() {
        return (this.mass * (this.vx * this.vx + this.vy * this.vy + this.vz * this.vz) + this.angMass * (this.angxVel * this.angxVel + this.angyVel * this.angyVel + this.angzVel * this.angzVel)) / 2.0;
    }

    @Override
    public ClassicalParticle3D move(double dt) {
        return this.rotate(dt).translate(dt);
    }

    public RigidBody3D rotate(double dt) {
        this.angx += this.angxVel * dt;
        if (this.angx > Math.PI * 2) {
            this.angx -= Math.PI * 2;
        } else if (this.angx < 0.0) {
            this.angx += Math.PI * 2;
        }
        this.angy += this.angyVel * dt;
        if (this.angy > Math.PI * 2) {
            this.angy -= Math.PI * 2;
        } else if (this.angy < 0.0) {
            this.angy += Math.PI * 2;
        }
        this.angz += this.angzVel * dt;
        if (this.angz > Math.PI * 2) {
            this.angz -= Math.PI * 2;
        } else if (this.angz < 0.0) {
            this.angz += Math.PI * 2;
        }
        return this;
    }

    public RigidBody3D angularAccelerate(double ax, double ay, double az, double dt) {
        this.angxVel += ax * dt;
        this.angyVel += ay * dt;
        this.angzVel += az * dt;
        return this;
    }

    public RigidBody3D applyTorque(double tx, double ty, double tz, double dt) {
        return this.angularAccelerate(tx / this.angMass, ty / this.angMass, tz / this.angMass, dt);
    }

    public RigidBody3D applyForce(double fx, double fy, double fz, double x, double y, double z, double dt) {
        this.applyTorque(y * fz - z * fy, z * fx - x * fz, x * fy - y * fx, dt);
        double k = (x * fx + y * fy + z * fz) / (x * x + y * y + z * z);
        this.applyForce(k * x, k * y, k * z, dt);
        return this;
    }
}

