/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.physics.ClassicalParticle2D;

public class RigidBody2D
extends ClassicalParticle2D {
    protected double angMass;
    protected double ang;
    protected double angVel;

    public void setMomentOfInertia(double MoI) {
        this.angMass = MoI;
    }

    public double getMomentOfInertia() {
        return this.angMass;
    }

    public void setAngle(double angle) {
        this.ang = angle;
    }

    public double getAngle() {
        return this.ang;
    }

    public void setAngularVelocity(double angleVel) {
        this.angVel = angleVel;
    }

    public double getAngularVelocity() {
        return this.angVel;
    }

    public void setAngularMomentum(double angleMom) {
        this.angVel = angleMom / this.angMass;
    }

    public double getAngularMomentum() {
        return this.angMass * this.angVel;
    }

    @Override
    public double energy() {
        return (this.mass * (this.vx * this.vx + this.vy * this.vy) + this.angMass * this.angVel * this.angVel) / 2.0;
    }

    @Override
    public ClassicalParticle2D move(double dt) {
        return this.rotate(dt).translate(dt);
    }

    public RigidBody2D rotate(double dt) {
        this.ang += this.angVel * dt;
        if (this.ang > Math.PI * 2) {
            this.ang -= Math.PI * 2;
        } else if (this.ang < 0.0) {
            this.ang += Math.PI * 2;
        }
        return this;
    }

    public RigidBody2D angularAccelerate(double a, double dt) {
        this.angVel += a * dt;
        return this;
    }

    public RigidBody2D applyTorque(double T, double dt) {
        return this.angularAccelerate(T / this.angMass, dt);
    }

    public RigidBody2D applyForce(double fx, double fy, double x, double y, double dt) {
        this.applyTorque(x * fy - y * fx, dt);
        double k = (x * fx + y * fy) / (x * x + y * y);
        this.applyForce(k * x, k * y, dt);
        return this;
    }

    public RigidBody2D collide(RigidBody2D p, double theta, double e) {
        double totalMass = this.mass + p.mass;
        double deltaVx = p.vx - this.vx;
        double deltaVy = p.vy - this.vy;
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        this.vx += p.mass * (e * (deltaVx * cos + deltaVy * sin) + deltaVx) / totalMass;
        this.vy += p.mass * (e * (deltaVy * cos - deltaVx * sin) + deltaVy) / totalMass;
        p.vx -= this.mass * (e * (deltaVx * cos + deltaVy * sin) + deltaVx) / totalMass;
        p.vy -= this.mass * (e * (deltaVy * cos - deltaVx * sin) + deltaVy) / totalMass;
        return this;
    }

    public RigidBody2D angularCollide(RigidBody2D p, double e) {
        double meanMass = (this.angMass + p.angMass) / (e + 1.0);
        double delta = p.angVel - this.angVel;
        this.angVel += p.angMass * delta / meanMass;
        p.angVel -= this.angMass * delta / meanMass;
        return this;
    }
}

