/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;
import jsci.physics.AbstractClassicalParticle;

public class Drag {
    private final double coefficient;

    public Drag(double coeff) {
        this.coefficient = coeff;
    }

    public Force createForce(AbstractClassicalParticle p) {
        return new Force(p);
    }

    private class Force
    extends jsci.physics.Force {
        private final AbstractClassicalParticle p;

        public Force(AbstractClassicalParticle p) {
            this.p = p;
        }

        @Override
        public AbstractDoubleVector getVector(double t) {
            AbstractDoubleVector pvel = this.p.getVelocity();
            double[] vec = new double[pvel.dimension()];
            double k = -Drag.this.coefficient * this.p.speed();
            for (int i = 0; i < vec.length; ++i) {
                vec[i] = k * pvel.getComponent(i);
            }
            return new DoubleVector(vec);
        }
    }
}

