/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.haar;

import jsci.maths.NumericalConstants;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.splines.PiecewiseConstant;

public final class MultiSplineHaar
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 0;
    static final double[] vg = new double[]{1.0, 1.0};
    static final double[] vog = new double[]{0.7071067811865475, -0.7071067811865475};

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return MultiSplineHaar.scaling(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return MultiSplineHaar.scaling(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return MultiSplineHaar.wavelet(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return MultiSplineHaar.wavelet(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)k / 2.0);
        if (2 * i == k) {
            return i;
        }
        throw new IllegalScalingException("Odd number of values into an even Filter. Please change the number of values.");
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + gete.length + " < 1");
        }
        double[] sortie = new double[2 * gete.length];
        for (int k = 0; k < gete.length; ++k) {
            int n = 2 * k;
            sortie[n] = sortie[n] + gete[k] * vg[0];
            int n2 = 2 * k + 1;
            sortie[n2] = sortie[n2] + gete[k] * vg[1];
        }
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        if (gete.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + gete.length + " < 1");
        }
        double[] sortie = new double[2 * gete.length];
        for (int k = 0; k < gete.length; ++k) {
            int n = 2 * k;
            sortie[n] = sortie[n] + gete[k] * vog[0];
            int n2 = 2 * k + 1;
            sortie[n2] = sortie[n2] + gete[k] * vog[1];
        }
        return sortie;
    }

    public static PiecewiseConstant scaling(int n0, int k) {
        if (k < 0 || n0 < 0 || k >= n0) {
            throw new IllegalArgumentException("Incorrect parameters : " + n0 + ", " + k);
        }
        double[] v = new double[n0];
        v[k] = 1.0;
        return new PiecewiseConstant(v);
    }

    public static PiecewiseConstant wavelet(int n0, int k) {
        if (k < 0 || n0 < 0 || k >= n0) {
            throw new IllegalArgumentException("Incorrect parameters : " + n0 + ", " + k);
        }
        double[] v = new double[2 * n0];
        v[2 * k] = vog[0];
        v[2 * k + 1] = vog[1];
        return new PiecewiseConstant(v);
    }
}

