/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies8;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies8.Daubechies8;

public final class Scaling8
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies8 cdf = new Daubechies8();

    public Scaling8(int N0, int K) {
        this.setParameters(N0, K);
    }

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof Scaling8) {
            Scaling8 iv = (Scaling8)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    public Scaling8() {
    }

    @Override
    public int getFilterType() {
        return 14;
    }

    public void setParameters(int N0, int K) {
        if (N0 < 28) {
            throw new IllegalScalingException(N0, 28);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public Object clone() {
        Scaling8 s = (Scaling8)super.clone();
        s.n0 = this.n0;
        s.k = this.k;
        return s;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalScaling(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin, 14);
    }

    @Override
    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

