/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies4;

import jsci.maths.ArrayMath;
import jsci.maths.NumericalConstants;
import jsci.maths.WaveletMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies4.Scaling4;
import jsci.maths.wavelet.daubechies4.Wavelet4;

public final class Daubechies4
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 6;
    protected static final int minlength = 12;
    static final double[] vg = new double[]{-0.107148901418, -0.0419109651251, 0.703739068656, 1.13665824341, 0.421234534204, -0.140317624179, -0.0178247014417, 0.045570345896};
    static final double[] v0temp = new double[]{0.798343492, 0.6022023488};
    static final double[] v1temp = new double[]{-0.03918024327, 0.05194149822, -0.4817281609, 0.8739021503};
    static final double[] v2temp = new double[]{0.0177470715, -0.0235274058, -0.1232594861, -0.06575127688, -0.09620570014, 0.9850684416};
    static final double[] v3temp = new double[]{-0.02636405192, 0.03495099166, 0.8114147375, 0.4440233637, 0.3192581817, 0.1636579832, -0.04282797155, 0.1094933054};
    static final double[] v4temp = new double[]{-0.01670338745, 0.02214378721, -0.01643714751, -0.01112580065, 0.2995602574, 0.02728668922, 0.8472064764, -0.4270166998, -0.03309408518, 0.08460780753};
    static final double[] v5temp = new double[]{0.002727915769, -0.003616415322, -0.05206157868, -0.02836107693, -0.04413123462, -0.01285294872, 0.454314169, 0.8282235028, 0.3000539798, -0.1037443976, -0.0126247089, 0.03227612835};
    static final double[] vd0temp = new double[]{0.7629809303, -0.6464209928};
    static final double[] vd1temp = new double[]{0.1555526564, 0.1836012627, 0.4620817399, -0.8535657052};
    static final double[] vd2temp = new double[]{0.3793246643, 0.4477229057, 0.4284467089, 0.3973740378, -0.2021221018, -0.522810622};
    static final double[] vd3temp = new double[]{0.2385999808, 0.2816233343, 0.1056438723, 0.161249877, 0.8548427132, 0.2929411663, -0.03647382801, -0.09324840384};
    static final double[] vd4temp = new double[]{0.06526723701, 0.07703595299, 0.07744666349, 0.07039069048, -0.06529437593, 0.2555397028, 0.8099281093, 0.496530082, -0.02995738718, -0.07658857572};
    static final double[] vd5temp = new double[]{0.001517778948, 0.001791458518, -0.003127686151, -0.001031248163, 0.03237561439, -0.01322822647, -0.09898430026, 0.2979273659, 0.8037308261, 0.4975940939, -0.02963560969, -0.07576592454};
    static final double[] v0 = ArrayMath.scalarMultiply(1.4142135623730951, v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply(1.4142135623730951, v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply(1.4142135623730951, v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply(1.4142135623730951, v3temp);
    static final double[] v4 = ArrayMath.scalarMultiply(1.4142135623730951, v4temp);
    static final double[] v5 = ArrayMath.scalarMultiply(1.4142135623730951, v5temp);
    static final double[] vd0 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd0temp));
    static final double[] vd1 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd1temp));
    static final double[] vd2 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd2temp));
    static final double[] vd3 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd3temp));
    static final double[] vd4 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd4temp));
    static final double[] vd5 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd5temp));
    static final double[] vgtemp = ArrayMath.scalarMultiply(0.7071067811865475, vg);
    static final double[] phvg = WaveletMath.lowToHigh(vgtemp);
    static final double[] phv0 = new double[]{0.5979027428, -0.7926434769, -0.01659403671, 0.06477069526, 0.09713044594, -0.0179703061, -3.192898087E-4, 8.162911886E-4};
    static final double[] phv1 = new double[]{0.04823971249, -0.06395169431, 0.3010034664, 0.1718883936, -0.8873256413, -0.03991915695, 0.2462565991, -0.1524149055, -0.009080945357, 0.02321619929};
    static final double[] phv2 = new double[]{-0.001162436086, 0.001541048928, 0.02218479707, 0.01208539488, 0.01880547055, 0.005476976811, -0.08114432093, -0.3089428579, 0.8028339176, -0.4957693566, -0.02962669767, 0.07574314021};
    static final double[] phvd0temp = new double[]{-0.4071236735, -0.4805345164, 0.7323866385, 0.2189246571, 0.1377492261, 0.006432723244, -5.725128723E-4, -0.001463677232};
    static final double[] phvd1temp = new double[]{-0.1510687974, -0.1783088929, -0.2220387683, -0.1860863787, 0.4453190824, -0.7578721319, 0.2811170011, 0.09317065817, -0.01190456353, -0.03043501623};
    static final double[] phvd2temp = new double[]{-0.003568796396, -0.004212306878, 0.007354216552, 0.002424802855, -0.07612569411, 0.03110390153, 0.4970737955, -0.8039165747, 0.2978757587, 0.09927560396, -0.01260377436, -0.03222260742};
    static final double[] phvd0 = ArrayMath.invert(phvd0temp);
    static final double[] phvd1 = ArrayMath.invert(phvd1temp);
    static final double[] phvd2 = ArrayMath.invert(phvd2temp);

    @Override
    public int getFilterType() {
        return 6;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return new Scaling4(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return new Scaling4(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return new Wavelet4(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return new Wavelet4(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        return Cascades.previousDimension(6, k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 12) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < " + 12);
        }
        double[] sortie = new double[2 * gete.length - 6];
        int dl0 = gete.length - 1;
        for (int k = 6; k <= dl0 - 6; ++k) {
            for (int L = -4; L < 4; ++L) {
                int n = 2 * k + L - 2;
                sortie[n] = sortie[n] + vg[L + 4] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], v0, 0);
        sortie = ArrayMath.add(sortie, gete[1], v1, 0);
        sortie = ArrayMath.add(sortie, gete[2], v2, 0);
        sortie = ArrayMath.add(sortie, gete[3], v3, 0);
        sortie = ArrayMath.add(sortie, gete[4], v4, 0);
        sortie = ArrayMath.add(sortie, gete[5], v5, 0);
        int p0 = sortie.length - vd0.length;
        int p1 = sortie.length - vd1.length;
        int p2 = sortie.length - vd2.length;
        int p3 = sortie.length - vd3.length;
        int p4 = sortie.length - vd4.length;
        int p5 = sortie.length - vd5.length;
        sortie = ArrayMath.add(sortie, gete[dl0], vd0, p0);
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], vd1, p1);
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], vd2, p2);
        sortie = ArrayMath.add(sortie, gete[dl0 - 3], vd3, p3);
        sortie = ArrayMath.add(sortie, gete[dl0 - 4], vd4, p4);
        sortie = ArrayMath.add(sortie, gete[dl0 - 5], vd5, p5);
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        double[] sortie = new double[2 * gete.length + 6];
        int dl0 = gete.length - 1;
        for (int k = 3; k <= dl0 - 3; ++k) {
            for (int L = -4; L < 4; ++L) {
                int n = 2 * k + L + 4;
                sortie[n] = sortie[n] + phvg[L + 4] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], phv0, 0);
        int p0 = sortie.length - phvd0.length;
        sortie = ArrayMath.add(sortie, gete[dl0], phvd0, p0);
        sortie = ArrayMath.add(sortie, gete[1], phv1, 0);
        int p1 = sortie.length - phvd1.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], phvd1, p1);
        sortie = ArrayMath.add(sortie, gete[2], phv2, 0);
        int p2 = sortie.length - phvd2.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], phvd2, p2);
        return sortie;
    }

    public double[] evalScaling(int n0, int k, int j1) {
        return Cascades.evalScaling(this, n0, j1, k);
    }

    public double[] evalWavelet(int n0, int k, int j1) {
        return Cascades.evalWavelet(this, 6, n0, j1, k);
    }
}

