/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf3_5;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.splines.QuadraticSpline;

public final class MultiSpline3_5
implements Filter {
    static final double[] vg = new double[]{0.25, 0.75, 0.75, 0.25};
    static final double[] v0 = new double[]{0.75, 0.25};
    static final double[] og = new double[]{0.0048828125, 0.0146484375, -0.0185546875, -0.0947265625, 0.025390625, 0.341796875, -0.341796875, -0.025390625, 0.0947265625, 0.0185546875, -0.0146484375, -0.0048828125};
    static final double[] o0 = new double[]{-0.77314453125, 0.28095703125, -0.1298486328125, -0.0055615234375, 0.038583984375, 0.002587890625, -0.0110107421875, -0.0022119140625, 0.001640625, 5.46875E-4};
    static final double[] o1 = new double[]{0.60908203125, -0.11689453125, -0.1900732421875, 0.3895458984375, -0.223740234375, -0.029931640625, 0.0481201171875, 0.0104150390625, -0.006328125, -0.002109375};
    static final double[] o2 = new double[]{-0.68603515625, 0.10009765625, 0.23994954427083334, -0.2664794921875, -0.198486328125, 0.4439290364583333, -0.1702880859375, -0.0411376953125, 0.017578125, 0.005859375};
    static final double[] on0_1 = ArrayMath.scalarMultiply(-1.0, ArrayMath.invert(o0));
    static final double[] on0_2 = ArrayMath.scalarMultiply(-1.0, ArrayMath.invert(o1));
    static final double[] on0_3 = ArrayMath.scalarMultiply(-1.0, ArrayMath.invert(o2));

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)(k - 2) / 2.0 + 2.0);
        if (2 * (i - 2) + 2 == k) {
            return i;
        }
        throw new IllegalScalingException("Odd number of values into an even Filter. Please change the number of values/iterations: " + k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 3) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < 3");
        }
        double[] sortie = new double[2 * gete.length - 2];
        for (int k = 1; k < gete.length - 1; ++k) {
            int n = 2 * k - 2;
            sortie[n] = sortie[n] + gete[k] * vg[0];
            int n2 = 2 * k - 1;
            sortie[n2] = sortie[n2] + gete[k] * vg[1];
            int n3 = 2 * k;
            sortie[n3] = sortie[n3] + gete[k] * vg[2];
            int n4 = 2 * k + 1;
            sortie[n4] = sortie[n4] + gete[k] * vg[3];
        }
        sortie[0] = sortie[0] + v0[0] * gete[0];
        sortie[1] = sortie[1] + v0[1] * gete[0];
        int n = sortie.length - 1;
        sortie[n] = sortie[n] + v0[0] * gete[gete.length - 1];
        int n5 = sortie.length - 2;
        sortie[n5] = sortie[n5] + v0[1] * gete[gete.length - 1];
        return sortie;
    }

    @Override
    public double[] highpass(double[] v) {
        int n0 = v.length + 2;
        double[] ans = ArrayMath.scalarMultiplyFast(v[0], MultiSpline3_5.wavelet(n0, 0).interpolate(0));
        for (int k = 1; k < v.length; ++k) {
            ans = ArrayMath.add(ans, ArrayMath.scalarMultiply(v[k], MultiSpline3_5.wavelet(n0, k).interpolate(0)));
        }
        return ans;
    }

    public static QuadraticSpline scaling(int n0, int k) {
        if (k < 0 || n0 < 0 || k >= n0) {
            throw new IllegalArgumentException("Incorrect parameters : " + n0 + ", " + k + " !");
        }
        if (n0 < 12) {
            throw new IllegalScalingException(n0, 12);
        }
        double[] v = new double[n0];
        v[k] = 1.0;
        return new QuadraticSpline(v);
    }

    public static QuadraticSpline wavelet(int n0, int k) {
        if (k < 0 || n0 < 0 || k >= n0 - 2) {
            throw new IllegalArgumentException("Incorrect parameters : " + n0 + ", " + k);
        }
        if (n0 < 12) {
            throw new IllegalScalingException(n0, 12);
        }
        double[] v = new double[2 * n0 - 2];
        if (k > 2 && k < n0 - 5) {
            v = ArrayMath.padding(v.length, 2 * k - 4, og);
        } else if (k == 0) {
            v = ArrayMath.padding(v.length, 0, o0);
        } else if (k == 1) {
            v = ArrayMath.padding(v.length, 0, o1);
        } else if (k == 2) {
            v = ArrayMath.padding(v.length, 0, o2);
        } else if (k == n0 - 3) {
            v = ArrayMath.padding(v.length, v.length - on0_1.length, on0_1);
        } else if (k == n0 - 4) {
            v = ArrayMath.padding(v.length, v.length - on0_2.length, on0_2);
        } else if (k == n0 - 5) {
            v = ArrayMath.padding(v.length, v.length - on0_3.length, on0_3);
        } else {
            throw new IllegalArgumentException("Oups!");
        }
        return new QuadraticSpline(v);
    }
}

