/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf3_5;

import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.cdf3_5.CDF3_5;

public final class DualScaling3_5
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static CDF3_5 cdf = new CDF3_5();

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof DualScaling3_5) {
            DualScaling3_5 iv = (DualScaling3_5)a;
            return this.dimension(0) == iv.dimension(0) && this.position() == iv.position();
        }
        return false;
    }

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][k=");
        ans.concat(Integer.toString(this.k));
        ans.concat("]");
        return ans;
    }

    @Override
    public int getFilterType() {
        return 2;
    }

    public DualScaling3_5(int N0, int K) {
        this.setParameters(N0, K);
    }

    @Override
    public Object clone() {
        DualScaling3_5 s = (DualScaling3_5)super.clone();
        s.n0 = this.n0;
        s.k = this.k;
        return s;
    }

    public DualScaling3_5() {
    }

    public void setParameters(int N0, int K) {
        if (N0 < 12) {
            throw new IllegalScalingException(N0, 12);
        }
        this.n0 = N0;
        this.k = K;
    }

    @Override
    public double[] evaluate(int j) {
        return cdf.evalScaling(this.n0, this.k, j);
    }

    @Override
    public int dimension(int jfin) {
        return Cascades.dimension(this.n0, jfin, 2);
    }

    @Override
    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

