/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf2_4;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.splines.LinearSpline;

public final class MultiSpline2_4
implements Filter {
    static final double[] vg = new double[]{0.5, 1.0, 0.5};
    static final double[] v0 = new double[]{1.0, 0.5};
    static final double[] og = new double[]{0.0234375, 0.046875, -0.125, -0.296875, 0.703125, -0.296875, -0.125, 0.046875, 0.0234375};
    static final double[] o0 = new double[]{-0.546875, 0.5696614583333334, -0.3138020833333333, -0.103515625, 0.10677083333333333, 0.043619791666666664, -0.01953125, -0.009765625};
    static final double[] on0_1 = ArrayMath.invert(o0);
    static final double[] o1 = new double[]{0.234375, -0.087890625, -0.41015625, 0.673828125, -0.2421875, -0.103515625, 0.03515625, 0.017578125};
    static final double[] on0_2 = ArrayMath.invert(o1);

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)(k + 1) / 2.0);
        if (2 * i - 1 == k) {
            return i;
        }
        throw new IllegalScalingException("Even number of values presented to an odd Filter. Please change the number of values/iterations.");
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] donnee) {
        if (donnee.length < 2) {
            throw new IllegalScalingException("The array is not long enough : " + donnee.length + " < 2");
        }
        double[] sortie = new double[2 * donnee.length - 1];
        for (int k = 1; k < donnee.length - 1; ++k) {
            int n = 2 * k - 1;
            sortie[n] = sortie[n] + donnee[k] * vg[0];
            int n2 = 2 * k;
            sortie[n2] = sortie[n2] + donnee[k] * vg[1];
            int n3 = 2 * k + 1;
            sortie[n3] = sortie[n3] + donnee[k] * vg[2];
        }
        sortie[0] = sortie[0] + v0[0] * donnee[0];
        sortie[1] = sortie[1] + v0[1] * donnee[0];
        int n = sortie.length - 1;
        sortie[n] = sortie[n] + v0[0] * donnee[donnee.length - 1];
        int n4 = sortie.length - 2;
        sortie[n4] = sortie[n4] + v0[1] * donnee[donnee.length - 1];
        return sortie;
    }

    @Override
    public double[] highpass(double[] v) {
        int n0 = v.length + 1;
        double[] ans = ArrayMath.scalarMultiplyFast(v[0], MultiSpline2_4.wavelet(n0, 0).interpolate(0));
        for (int k = 1; k < v.length; ++k) {
            ans = ArrayMath.add(ans, ArrayMath.scalarMultiply(v[k], MultiSpline2_4.wavelet(n0, k).interpolate(0)));
        }
        return ans;
    }

    public static LinearSpline hat(int n0, int k) {
        if (k < 0 || n0 < 0 || k >= n0) {
            throw new IllegalArgumentException("Incorrect parameters : " + n0 + ", " + k + " !");
        }
        if (n0 < 5) {
            throw new IllegalScalingException(n0, 5);
        }
        double[] v = new double[n0];
        v[k] = 1.0;
        return new LinearSpline(v);
    }

    public static LinearSpline scaling(int n0, int k) {
        return MultiSpline2_4.hat(n0, k);
    }

    public static LinearSpline wavelet(int n0, int k) {
        if (k < 0 || n0 < 0 || k >= n0 - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + n0 + ", " + k);
        }
        if (n0 < 5) {
            throw new IllegalScalingException(n0, 5);
        }
        double[] v = new double[2 * n0 - 1];
        if (k > 1 && k < n0 - 3) {
            v = ArrayMath.padding(v.length, 2 * k - 4 + 1, og);
        } else if (k == 0) {
            v = ArrayMath.padding(v.length, 0, o0);
        } else if (k == 1) {
            v = ArrayMath.padding(v.length, 0, o1);
        } else if (k == n0 - 2) {
            v = ArrayMath.padding(v.length, v.length - on0_1.length, on0_1);
        } else if (k == n0 - 3) {
            v = ArrayMath.padding(v.length, v.length - on0_2.length, on0_2);
        } else {
            throw new IllegalArgumentException("Oups!");
        }
        return new LinearSpline(v);
    }
}

