/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf2_4;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.cdf2_4.DualScaling2_4;
import jsci.maths.wavelet.cdf2_4.DualWavelet2_4;
import jsci.maths.wavelet.cdf2_4.MultiSpline2_4;

public final class CDF2_4
extends Multiresolution
implements Filter {
    protected static final int filtretype = 1;
    protected static final int minlength = 5;
    static final double[] vg = new double[]{0.046875, -0.09375, -0.25, 0.59375, 1.40625, 0.59375, -0.25, -0.09375, 0.046875};
    static final double[] v3 = new double[]{-0.01953125, 0.0390625, 0.015625, -0.0703125, -0.26171875, 0.59375, 1.40625, 0.59375, -0.25, -0.09375, 0.046875};
    static final double[] v2 = new double[]{0.10677083333333333, -0.21354166666666666, -0.13541666666666666, 0.484375, 1.4609375, 0.59375, -0.25, -0.09375, 0.046875};
    static final double[] v1 = new double[]{-0.3138020833333333, 0.6276041666666666, 1.2760416666666667, 0.8203125, -0.36328125, -0.09375, 0.046875};
    static final double[] v0 = new double[]{1.453125, 1.09375, -0.3125, -0.46875, 0.234375};
    static final double[] vd0 = ArrayMath.invert(v0);
    static final double[] vd1 = ArrayMath.invert(v1);
    static final double[] vd2 = ArrayMath.invert(v2);
    static final double[] vd3 = ArrayMath.invert(v3);
    static final double[] phvg = new double[]{-0.5, 1.0, -0.5};
    static final double[] phv0 = new double[]{1.0, -0.5};

    @Override
    public int getFilterType() {
        return 1;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return MultiSpline2_4.scaling(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return new DualScaling2_4(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return MultiSpline2_4.wavelet(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return new DualWavelet2_4(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        int i = (int)Math.round((double)(k + 1) / 2.0);
        if (2 * i - 1 == k) {
            return i;
        }
        throw new IllegalScalingException("Even number of values into an odd Filter! Change the number of iterations/values.");
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 8) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < 8");
        }
        double[] sortie = new double[2 * gete.length - 1];
        int dl0 = gete.length - 1;
        for (int k = 4; k <= dl0 - 4; ++k) {
            for (int L = -4; L <= 4; ++L) {
                int n = 2 * k + L;
                sortie[n] = sortie[n] + vg[L + 4] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], v0, 0);
        sortie = ArrayMath.add(sortie, gete[1], v1, 0);
        sortie = ArrayMath.add(sortie, gete[2], v2, 0);
        sortie = ArrayMath.add(sortie, gete[3], v3, 0);
        int p0 = sortie.length - vd0.length;
        int p1 = sortie.length - vd1.length;
        int p2 = sortie.length - vd2.length;
        int p3 = sortie.length - vd3.length;
        sortie = ArrayMath.add(sortie, gete[dl0], vd0, p0);
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], vd1, p1);
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], vd2, p2);
        sortie = ArrayMath.add(sortie, gete[dl0 - 3], vd3, p3);
        return sortie;
    }

    @Override
    public double[] highpass(double[] v) {
        if (v.length < 2) {
            throw new IllegalScalingException("The array is not long enough : " + v.length + " < 2");
        }
        double[] data = Cascades.supersample(v);
        int dl = data.length - 1;
        double[] sortie = new double[data.length];
        for (int k = 1; k <= dl - 1; ++k) {
            sortie[k] = ArrayMath.scalarProduct(ArrayMath.extract(k - 1, k + 1, data), phvg);
        }
        sortie[0] = ArrayMath.scalarProduct(ArrayMath.extract(0, 1, data), phv0);
        sortie[dl] = ArrayMath.scalarProduct(ArrayMath.extract(dl, dl - 1, data), phv0);
        return sortie;
    }

    public double[] evalScaling(int n0, int k, int j1) {
        return Cascades.evalScaling(this, n0, j1, k);
    }

    public double[] evalWavelet(int n0, int k, int j1) {
        return Cascades.evalWavelet(this, n0, j1, k);
    }
}

