/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import java.util.Arrays;
import jsci.GlobalSettings;
import jsci.maths.ArrayMath;
import jsci.maths.Complex;
import jsci.maths.EngineerMath;
import jsci.maths.FourierMath;
import jsci.maths.MappingND;
import jsci.maths.NumericalConstants;
import jsci.maths.wavelet.FWTCoef;
import jsci.maths.wavelet.FWTPacketCoef;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.splines.LinearSpline;

public class Signal
extends LinearSpline
implements NumericalConstants,
Cloneable {
    private Filter filterdual;
    static final double normalisation = 0.7071067811865475;
    private double[] param;

    @Override
    public Object clone() {
        Signal s = (Signal)super.clone();
        if (this.filterdual != null) {
            s.filterdual = this.filterdual;
        }
        if (this.param != null) {
            s.param = new double[this.param.length];
            System.arraycopy(s.param, 0, this.param, 0, this.param.length);
        }
        return s;
    }

    private Signal copy(double[] v) {
        if (this.filterdual != null) {
            if (this.param != null) {
                double[] p = new double[this.param.length];
                System.arraycopy(this.param, 0, p, 0, p.length);
                return new Signal(this.filterdual, v, p);
            }
            return new Signal(this.filterdual, v);
        }
        return new Signal(v);
    }

    public Signal() {
    }

    public Signal(double[] v) {
        super(v);
    }

    public Signal(Filter f, double[] v, double[] p) {
        super(v);
        this.filterdual = f;
        System.arraycopy(p, 0, this.param, 0, this.param.length);
    }

    public Signal(Filter f) {
        this.filterdual = f;
    }

    public Signal(Filter f, double[] v) {
        super(v);
        this.filterdual = f;
    }

    public double[] getValues() {
        return this.interpolate(0);
    }

    public void setFilter(Filter f) {
        this.filterdual = f;
    }

    public void setParameters(double[] p) {
        for (int k = 0; k < p.length; ++k) {
            this.param[k] = p[k];
        }
    }

    public void setParameters(Double[] p) {
        for (int k = 0; k < p.length; ++k) {
            this.param[k] = p[k];
        }
    }

    public void removeParameters() {
        this.param = null;
    }

    public void setLengthFromEnd(int longueur) {
        double[] newvec = ArrayMath.setLengthFromEnd(this.evaluate(0), longueur);
        this.setValues(newvec);
    }

    public void resample(int newl) {
        double[] newvec = EngineerMath.resample(this.evaluate(0), newl);
        this.setValues(newvec);
    }

    public void setLengthFromBeginning(int longueur) {
        double[] newvec = ArrayMath.setLengthFromBeginning(this.evaluate(0), longueur);
        this.setValues(newvec);
    }

    public void setData(double[] v) {
        this.setValues(v);
    }

    public FWTCoef fwt(int J) {
        if (J > 20) {
            throw new IllegalArgumentException("Too many iterations.");
        }
        if (J < 0) {
            throw new IllegalArgumentException("Cannot have a negative number of iterations.");
        }
        double[] data = this.interpolate(0);
        double[][] fwt = new double[J + 1][];
        for (int j = 1; j <= J; ++j) {
            fwt[j] = this.highpassProject(data);
            data = this.lowpassProject(data);
        }
        fwt[0] = data;
        FWTCoef t = new FWTCoef(fwt);
        return t;
    }

    public FWTPacketCoef fwtPacket(int J, MappingND cout) {
        if (J > 20) {
            throw new IllegalArgumentException("Too many iterations.");
        }
        if (J < 0) {
            throw new IllegalArgumentException("Cannot have a negative number of iterations.");
        }
        double[] data = this.interpolate(0);
        double[][] fwt = new double[J + 1][];
        boolean[] choixStandard = new boolean[J];
        for (int j = 0; j < J; ++j) {
            double[] choix1 = this.highpassProject(data);
            double[] choix2 = this.lowpassProject(data);
            if (cout.map(choix1)[0] < cout.map(choix2)[0]) {
                fwt[j] = choix1;
                data = choix2;
                choixStandard[j] = true;
                continue;
            }
            data = choix1;
            fwt[j] = choix2;
            choixStandard[j] = false;
        }
        fwt[J] = data;
        FWTPacketCoef t = new FWTPacketCoef(fwt, choixStandard);
        return t;
    }

    private double[] lowpassProject(double[] v) {
        int l = this.filterdual.previousDimension(v.length);
        double[] ans = new double[l];
        if (this.param != null) {
            for (int i = 0; i < l; ++i) {
                double[] p = new double[this.param.length];
                System.arraycopy(this.param, 0, p, 0, p.length);
                double[] Eche = this.filterdual.lowpass(this.delta(i, l, 0.7071067811865475), p);
                ans[i] = Signal.scalarProduct(v, Eche);
            }
        } else {
            for (int i = 0; i < l; ++i) {
                double[] Eche = this.filterdual.lowpass(this.delta(i, l, 0.7071067811865475));
                ans[i] = Signal.scalarProduct(v, Eche);
            }
        }
        return ans;
    }

    private static double scalarProduct(double[] w0, double[] w1) {
        double sortie = 0.0;
        for (int k = 0; k < w0.length; ++k) {
            sortie += w0[k] * w1[k];
        }
        return sortie;
    }

    public double[] lowpassProject() {
        double[] data = this.interpolate(0);
        return this.lowpassProject(data);
    }

    private double[] highpassProject(double[] v) {
        int l = this.filterdual.previousDimension(v.length);
        int lOnd = v.length - l;
        double[] ans = new double[lOnd];
        if (this.param != null) {
            for (int i = 0; i < lOnd; ++i) {
                double[] p = new double[this.param.length];
                System.arraycopy(this.param, 0, p, 0, p.length);
                double[] Onde = this.filterdual.highpass(this.delta(i, lOnd, 1.0), p);
                ans[i] = Signal.scalarProduct(v, Onde);
            }
        } else {
            for (int i = 0; i < lOnd; ++i) {
                double[] Onde = this.filterdual.highpass(this.delta(i, lOnd, 1.0));
                ans[i] = Signal.scalarProduct(v, Onde);
            }
        }
        return ans;
    }

    public double[] highpassProject() {
        double[] data = this.interpolate(0);
        return this.highpassProject(data);
    }

    private double[] delta(int i, int l, double a) {
        if (i < 0 || i > l || l < 0) {
            throw new IllegalArgumentException("This Kronecker doesn't exist.");
        }
        double[] v = new double[l];
        v[i] = a;
        return v;
    }

    public double norm() {
        double[] data = this.interpolate(0);
        return ArrayMath.norm(data);
    }

    public Complex[] fft() {
        double[] data = this.interpolate(0);
        return Signal.fft(data);
    }

    public static Complex[] fft(double[] data) {
        return FourierMath.transform(data);
    }

    public static Complex[] fft(Complex[] data) {
        return FourierMath.transform(data);
    }

    public double[] absFFT() {
        Complex[] fft = this.fft();
        double[] answer = new double[fft.length];
        for (int i = 0; i < fft.length; ++i) {
            answer[i] = fft[i].mod();
        }
        return answer;
    }

    public static double[] absFFT(double[] data) {
        Complex[] fft = Signal.fft(data);
        double[] answer = new double[fft.length];
        for (int i = 0; i < fft.length; ++i) {
            answer[i] = fft[i].mod();
        }
        return answer;
    }

    public static Complex[] fftInverse(Complex[] data) {
        return FourierMath.inverseTransform(data);
    }

    public boolean equals(Signal b) {
        return Arrays.equals(this.getValues(), b.getValues());
    }

    public void setDimensionFromEnd(int dimension) {
        double[] data = this.interpolate(0);
        double[] ans = new double[dimension];
        int debut = dimension - data.length < 0 ? data.length - dimension : 0;
        for (int k = debut; k < data.length; ++k) {
            ans[k + dimension - data.length] = data[k];
        }
        super.setValues(ans);
    }

    public void setDimensionFromBeginning(int dimension) {
        double[] data = this.interpolate(0);
        double[] ans = new double[dimension];
        int debut = dimension - data.length < 0 ? data.length - dimension : 0;
        for (int k = 0; k < data.length - debut; ++k) {
            ans[k] = data[k];
        }
        super.setValues(ans);
    }

    public void denoiseByFFT(int k) {
        if (k < 1) {
            throw new IllegalArgumentException("This parameter must be 1 or more : " + k);
        }
        double[] data = this.interpolate(0);
        if (k > data.length - 2) {
            if (data.length < 4) {
                throw new IllegalArgumentException("Your signal is too short to be denoised : " + data.length + " < 4");
            }
            throw new IllegalArgumentException("Since you signal has dimension " + data.length + ", the parameter must be at most : " + (data.length - 2));
        }
        Complex[] ff = Signal.fft(data);
        ff[k + 1] = Complex.ZERO;
        ff[data.length - 1 - k] = Complex.ZERO;
        Complex[] tf = Signal.fftInverse(ff);
        for (int l = 0; l < data.length; ++l) {
            data[l] = tf[l].real();
            if (!(Math.abs(tf[l].imag()) > GlobalSettings.ZERO_TOL)) continue;
            throw new IllegalArgumentException("Complex values detected during synthesis. Please get in touch with Daniel Lemire at Daniel.Lemire@Tintin.net to report this error.");
        }
        super.setValues(data);
    }

    public double entropy() {
        return EngineerMath.entropy(this.evaluate(0));
    }

    public Signal filter(double[] f) {
        double[] data = this.interpolate(0);
        if (data.length - (f.length - 1) <= 0) {
            throw new IllegalArgumentException("Your signal is too short for this Filter : " + data.length + ", " + f.length);
        }
        double[] ans = new double[data.length - (f.length - 1)];
        for (int k = 0; k < data.length - (f.length - 1); ++k) {
            for (int l = 0; l < f.length; ++l) {
                int n = k;
                ans[n] = ans[n] + f[l] * data[k + l];
            }
        }
        return this.copy(ans);
    }

    public Signal medianFilter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive: " + n + " < 0");
        }
        double[] data = super.interpolate(0);
        if (data.length - 2 * n <= 0) {
            throw new IllegalArgumentException("Your signal is too short for this Filter : " + data.length + " - " + 2 * n + " = " + (data.length - 2 * n));
        }
        double[] ans = new double[data.length - 2 * n];
        double[] vtemp = new double[2 * n + 1];
        for (int k = 0; k < data.length - 2 * n; ++k) {
            for (int l = 0; l < 2 * n + 1; ++l) {
                vtemp[l] = data[k + l];
            }
            ans[k] = ArrayMath.median(vtemp);
        }
        return this.copy(ans);
    }

    public Signal denoiseShortPeaks(double p, int n) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("The parameter p must be between 0 and 1: " + p);
        }
        double[] values = this.interpolate(0);
        double range = ArrayMath.max(values) - ArrayMath.min(values);
        double threshold = range * p;
        double[] med = this.medianFilter(n).interpolate(0);
        for (int k = n; k < values.length - n; ++k) {
            if (!(Math.abs(values[k] - med[k - n]) > threshold)) continue;
            values[k] = med[k - n];
        }
        return this.copy(values);
    }
}

