/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import jsci.maths.ArrayMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.wavelet.BasisFunctionLibrary;
import jsci.maths.wavelet.Cosine;
import jsci.maths.wavelet.DiscreteFunction;
import jsci.maths.wavelet.DiscreteHilbertSpace;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.Sine;

public class MatchingPursuit
extends BasisFunctionLibrary
implements Cloneable {
    private int[] Record;
    private double[] Coefs;
    private double[][][] TF = new double[0][][];

    @Override
    public void add(MultiscaleFunction fprimary, MultiscaleFunction fdual) {
        super.add(fprimary, fdual);
        double[][][] TFback = this.TF;
        this.TF = new double[this.getSize()][][];
        System.arraycopy(TFback, 0, this.TF, 0, TFback.length);
        this.TF[this.getSize() - 1] = this.getTF(this.Fprimary[this.getSize() - 1]);
    }

    @Override
    public Object clone() {
        MatchingPursuit c = (MatchingPursuit)super.clone();
        if (this.Record != null) {
            c.Record = ArrayMath.copy(this.Record);
        }
        if (this.Coefs != null) {
            c.Coefs = ArrayMath.copy(this.Coefs);
        }
        if (this.TF != null) {
            this.TF = new double[this.TF.length][][];
            System.arraycopy(this.TF, 0, c.TF, 0, this.TF.length);
        }
        return c;
    }

    private void addToRecord(int K, double d) {
        if (this.Record == null) {
            this.Record = new int[1];
            this.Record[0] = K;
            this.Coefs = new double[1];
            this.Coefs[0] = d;
        } else {
            int[] back = this.Record;
            double[] backednorm = this.Coefs;
            this.Record = new int[this.Record.length + 1];
            this.Coefs = new double[this.Record.length + 1];
            System.arraycopy(back, 0, this.Record, 0, this.Record.length - 1);
            System.arraycopy(backednorm, 0, this.Coefs, 0, this.Record.length - 1);
            this.Record[this.Record.length - 1] = K;
            this.Coefs[this.Record.length - 1] = d;
        }
    }

    public int[] getRecord() {
        return this.Record;
    }

    public double[] getRecordedNorms() {
        double[] ans = new double[this.Record.length];
        for (int k = 0; k < this.Record.length; ++k) {
            ans[k] = Math.abs(this.Coefs[k]) * this.Fprimary[k].norm();
        }
        return ans;
    }

    public double[] getCoefs() {
        return this.Coefs;
    }

    public MatchingPursuit(DiscreteFunction f) {
        super(f);
    }

    @Override
    public void setData(DiscreteFunction f) {
        if (this.DFunction != null && f.dimension() != this.DFunction.dimension()) {
            throw new IllegalArgumentException("You cannot change the dimension of the data object. Please create a new object.");
        }
        this.DFunction = (DiscreteFunction)f.clone();
        this.Record = null;
        this.Coefs = null;
    }

    private MatchingPursuit() {
    }

    public void diagnostic(double tol) throws MaximumIterationsExceededException {
        if (tol < 0.0) {
            throw new IllegalArgumentException("A tolerance cannot be negative :" + tol + " < 0");
        }
        MatchingPursuit testmatch = (MatchingPursuit)this.clone();
        for (int k = 0; k < this.getSize(); ++k) {
            testmatch.DFunction = (DiscreteFunction)this.Fprimary[k].clone();
            double ener1 = testmatch.DFunction.norm();
            testmatch.match();
            double ener2 = testmatch.DFunction.norm();
            if (!(ener2 > ener1 * tol)) continue;
            throw new IllegalArgumentException("Fail to match dictionnary element number " + k + " got a 'de facto' tolerance of " + ener2 / ener1);
        }
    }

    private double[][] getTF(int pos, double b) {
        double[][] ans = ArrayMath.copy(this.TF[pos]);
        for (int k = 0; k < ans.length; ++k) {
            int l = 0;
            while (l < ans[k].length) {
                double[] dArray = ans[k];
                int n = l++;
                dArray[n] = dArray[n] * b;
            }
        }
        return ans;
    }

    private double[][] getTF(DiscreteFunction a) {
        int freqlength = (int)Math.ceil((double)this.DFunction.dimension() / 2.0);
        double[][] TF = new double[freqlength][this.DFunction.dimension()];
        double[] time = a.evaluate(0);
        for (int k = 0; k < freqlength; ++k) {
            double freq = MatchingPursuit.norm(DiscreteHilbertSpace.integrate(a, new Cosine(this.DFunction.dimension(), k)), DiscreteHilbertSpace.integrate(a, new Sine(this.DFunction.dimension(), k)));
            for (int l = 0; l < this.DFunction.dimension(); ++l) {
                TF[k][l] = time[l] * freq;
            }
        }
        return TF;
    }

    public double[][] match() {
        double coef = this.getWeigth(0);
        int pos = 0;
        double min = this.getResidue(0);
        for (int k = 1; k < this.getSize(); ++k) {
            double weigthtemp = DiscreteHilbertSpace.integrate(this.DFunction, this.Fdual[k]);
            double[] soltemp = DiscreteHilbertSpace.add(this.DFunction, -weigthtemp, this.Fprimary[k]);
            double resitemp = ArrayMath.norm(soltemp);
            if (!(resitemp < min)) continue;
            min = resitemp;
            coef = weigthtemp;
            pos = k;
        }
        this.addToRecord(pos, coef);
        this.DFunction = new DiscreteFunction(DiscreteHilbertSpace.add(this.DFunction, -coef, this.Fprimary[pos]));
        return this.getTF(pos, coef);
    }

    public double[][] matchAll(double tol) throws MaximumIterationsExceededException {
        if (tol > 1.0 || tol < 0.0) {
            throw new IllegalArgumentException("The percentile should be between 0 and 1: " + tol);
        }
        int TimesAround = 0;
        double ener0 = this.DFunction.norm();
        double ts = ener0 * tol;
        int maxTimesAround = 5 * this.getSize();
        double[][] ans = new double[0][0];
        while (this.DFunction.norm() > ts) {
            if (++TimesAround > maxTimesAround) {
                throw new MaximumIterationsExceededException("Impossible to match to the desired precision (" + tol + ") with this dictionnary of size " + this.getSize() + " after " + TimesAround + " iterations. You might want to expand the dictionnary.");
            }
            if (ans.length != 0) {
                ans = MatchingPursuit.add(ans, this.match());
                continue;
            }
            ans = this.match();
        }
        return ans;
    }

    public double[][] forcedMatch(int pos) {
        double coef = DiscreteHilbertSpace.integrate(this.DFunction, this.Fdual[pos]);
        this.addToRecord(pos, coef);
        this.DFunction = new DiscreteFunction(DiscreteHilbertSpace.add(this.DFunction, -coef, this.Fprimary[pos]));
        return this.getTF(pos, coef);
    }

    public double[][] match(int j) {
        if (j <= 0) {
            throw new IllegalArgumentException("Can't do " + j + " matching... Must be a positive number.");
        }
        double[][] ans = this.match();
        for (int k = 1; k < j; ++k) {
            ans = MatchingPursuit.add(ans, this.match());
        }
        return ans;
    }
}

