/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.ExtraMath;
import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.ComplexVector;
import jsci.maths.vectors.DoubleVector;
import jsci.maths.vectors.VectorDimensionException;

public class IntegerVector
extends AbstractIntegerVector {
    protected int[] vector;

    public IntegerVector(int dim) {
        super(dim);
        this.vector = new int[dim];
    }

    public IntegerVector(int[] array) {
        super(array.length);
        this.vector = array;
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof AbstractIntegerVector && this.N == ((AbstractIntegerVector)a).N) {
            AbstractIntegerVector iv = (AbstractIntegerVector)a;
            int sumSqr = 0;
            for (int i = 0; i < this.N; ++i) {
                int delta = this.vector[i] - iv.getComponent(i);
                sumSqr += delta * delta;
            }
            return sumSqr == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(this.N);
        for (i = 0; i < this.N - 1; ++i) {
            buf.append(this.vector[i]);
            buf.append(',');
        }
        buf.append(this.vector[i]);
        return buf.toString();
    }

    @Override
    public AbstractDoubleVector toDoubleVector() {
        double[] array = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            array[i] = this.vector[i];
        }
        return new DoubleVector(array);
    }

    public AbstractComplexVector toComplexVector() {
        double[] arrayRe = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            arrayRe[i] = this.vector[i];
        }
        return new ComplexVector(arrayRe, new double[this.N]);
    }

    @Override
    public int getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(IntegerVector.getInvalidComponentMsg(n));
    }

    @Override
    public void setComponent(int n, int x) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(IntegerVector.getInvalidComponentMsg(n));
        }
        this.vector[n] = x;
    }

    @Override
    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.vector[0]), n);
        for (int i = 1; i < this.N; ++i) {
            answer += Math.pow(Math.abs(this.vector[i]), n);
        }
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        double answer = this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            answer = ExtraMath.hypot(answer, this.vector[i]);
        }
        return answer;
    }

    @Override
    public double infNorm() {
        int infNorm = Math.abs(this.vector[0]);
        for (int i = 1; i < this.N; ++i) {
            int abs = Math.abs(this.vector[i]);
            if (abs <= infNorm) continue;
            infNorm = abs;
        }
        return infNorm;
    }

    @Override
    public AbelianGroup.Member negate() {
        int[] array = new int[this.N];
        array[0] = -this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            array[i] = -this.vector[i];
        }
        return new IntegerVector(array);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member v) {
        if (v instanceof IntegerVector) {
            return this.add((IntegerVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractIntegerVector add(AbstractIntegerVector v) {
        if (v instanceof IntegerVector) {
            return this.add((IntegerVector)v);
        }
        if (this.N == v.N) {
            int[] array = new int[this.N];
            array[0] = this.vector[0] + v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] + v.getComponent(i);
            }
            return new IntegerVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public IntegerVector add(IntegerVector v) {
        if (this.N == v.N) {
            int[] array = new int[this.N];
            array[0] = this.vector[0] + v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] + v.vector[i];
            }
            return new IntegerVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member v) {
        if (v instanceof IntegerVector) {
            return this.subtract((IntegerVector)v);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractIntegerVector subtract(AbstractIntegerVector v) {
        if (v instanceof IntegerVector) {
            return this.subtract((IntegerVector)v);
        }
        if (this.N == v.N) {
            int[] array = new int[this.N];
            array[0] = this.vector[0] - v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] - v.getComponent(i);
            }
            return new IntegerVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public IntegerVector subtract(IntegerVector v) {
        if (this.N == v.N) {
            int[] array = new int[this.N];
            array[0] = this.vector[0] - v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                array[i] = this.vector[i] - v.vector[i];
            }
            return new IntegerVector(array);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractIntegerVector scalarMultiply(int x) {
        int[] array = new int[this.N];
        array[0] = x * this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            array[i] = x * this.vector[i];
        }
        return new IntegerVector(array);
    }

    @Override
    public int scalarProduct(AbstractIntegerVector v) {
        if (v instanceof IntegerVector) {
            return this.scalarProduct((IntegerVector)v);
        }
        if (this.N == v.N) {
            int answer = this.vector[0] * v.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                answer += this.vector[i] * v.getComponent(i);
            }
            return answer;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public int scalarProduct(IntegerVector v) {
        if (this.N == v.N) {
            int answer = this.vector[0] * v.vector[0];
            for (int i = 1; i < this.N; ++i) {
                answer += this.vector[i] * v.vector[i];
            }
            return answer;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }
}

