/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.Mapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.Complex2Vector;
import jsci.maths.vectors.Integer2Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class Double2Vector
extends AbstractDoubleVector {
    protected double x;
    protected double y;

    public Double2Vector() {
        super(2);
    }

    public Double2Vector(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public Double2Vector(double[] array) {
        this();
        this.x = array[0];
        this.y = array[1];
    }

    @Override
    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof Double2Vector) {
            Double2Vector vec = (Double2Vector)obj;
            double dx = this.x - vec.x;
            double dy = this.y - vec.y;
            return dx * dx + dy * dy <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(15);
        buf.append(this.x).append(',').append(this.y);
        return buf.toString();
    }

    public AbstractIntegerVector toIntegerVector() {
        return new Integer2Vector(Math.round((float)this.x), Math.round((float)this.y));
    }

    public AbstractComplexVector toComplexVector() {
        return new Complex2Vector(this.x, 0.0, this.y, 0.0);
    }

    @Override
    public double getComponent(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public void setComponent(int n, double value) {
        switch (n) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.x), n) + Math.pow(Math.abs(this.y), n);
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double infNorm() {
        double infNorm = 0.0;
        double abs = Math.abs(this.x);
        if (abs > infNorm) {
            infNorm = abs;
        }
        if ((abs = Math.abs(this.y)) > infNorm) {
            infNorm = abs;
        }
        return infNorm;
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Double2Vector(-this.x, -this.y);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member vec) {
        if (vec instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector add(AbstractDoubleVector vec) {
        if (vec.N == 2) {
            return new Double2Vector(this.x + vec.getComponent(0), this.y + vec.getComponent(1));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member vec) {
        if (vec instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector subtract(AbstractDoubleVector vec) {
        if (vec.N == 2) {
            return new Double2Vector(this.x - vec.getComponent(0), this.y - vec.getComponent(1));
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarMultiply(double k) {
        return new Double2Vector(k * this.x, k * this.y);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractDoubleVector scalarDivide(double k) {
        return new Double2Vector(this.x / k, this.y / k);
    }

    @Override
    public double scalarProduct(AbstractDoubleVector vec) {
        if (vec.N == 2) {
            return this.x * vec.getComponent(0) + this.y * vec.getComponent(1);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbstractDoubleVector mapComponents(Mapping mapping) {
        return new Double2Vector(mapping.map(this.x), mapping.map(this.y));
    }
}

