/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.HilbertSpace;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.Double3Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class Complex3Vector
extends AbstractComplexVector {
    protected double xre;
    protected double xim;
    protected double yre;
    protected double yim;
    protected double zre;
    protected double zim;

    public Complex3Vector() {
        super(3);
    }

    public Complex3Vector(Complex x, Complex y, Complex z) {
        this();
        this.xre = x.real();
        this.xim = x.imag();
        this.yre = y.real();
        this.yim = y.imag();
        this.zre = z.real();
        this.zim = z.imag();
    }

    public Complex3Vector(double xRe, double xIm, double yRe, double yIm, double zRe, double zIm) {
        this();
        this.xre = xRe;
        this.xim = xIm;
        this.yre = yRe;
        this.yim = yIm;
        this.zre = zRe;
        this.zim = zIm;
    }

    @Override
    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof Complex3Vector) {
            Complex3Vector vec = (Complex3Vector)obj;
            double dxRe = this.xre - vec.xre;
            double dxIm = this.xim - vec.xim;
            double dyRe = this.yre - vec.yre;
            double dyIm = this.yim - vec.yim;
            double dzRe = this.zre - vec.zre;
            double dzIm = this.zim - vec.zim;
            return dxRe * dxRe + dxIm * dxIm + dyRe * dyRe + dyIm * dyIm + dzRe * dzRe + dzIm * dzIm <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(15);
        buf.append(Complex.toString(this.xre, this.xim)).append(',').append(Complex.toString(this.yre, this.yim)).append(',').append(Complex.toString(this.zre, this.zim));
        return buf.toString();
    }

    @Override
    public AbstractDoubleVector real() {
        return new Double3Vector(this.xre, this.yre, this.zre);
    }

    @Override
    public AbstractDoubleVector imag() {
        return new Double3Vector(this.xim, this.yim, this.zim);
    }

    @Override
    public Complex getComponent(int n) {
        switch (n) {
            case 0: {
                return new Complex(this.xre, this.xim);
            }
            case 1: {
                return new Complex(this.yre, this.yim);
            }
            case 2: {
                return new Complex(this.zre, this.zim);
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public double getRealComponent(int n) {
        switch (n) {
            case 0: {
                return this.xre;
            }
            case 1: {
                return this.yre;
            }
            case 2: {
                return this.zre;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public double getImagComponent(int n) {
        switch (n) {
            case 0: {
                return this.xim;
            }
            case 1: {
                return this.yim;
            }
            case 2: {
                return this.zim;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public void setComponent(int n, Complex z) {
        switch (n) {
            case 0: {
                this.xre = z.real();
                this.xim = z.imag();
                break;
            }
            case 1: {
                this.yre = z.real();
                this.yim = z.imag();
                break;
            }
            case 2: {
                this.zre = z.real();
                this.zim = z.imag();
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public void setComponent(int n, double x, double y) {
        switch (n) {
            case 0: {
                this.xre = x;
                this.xim = y;
                break;
            }
            case 1: {
                this.yre = x;
                this.yim = y;
                break;
            }
            case 2: {
                this.zre = x;
                this.zim = y;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public double norm() {
        return Math.sqrt(this.xre * this.xre + this.xim * this.xim + this.yre * this.yre + this.yim * this.yim + this.zre * this.zre + this.zim * this.zim);
    }

    @Override
    public double infNorm() {
        double modSq = this.xre * this.xre + this.xim * this.xim;
        double infNormSq = 0.0;
        if (modSq > infNormSq) {
            infNormSq = modSq;
        }
        if ((modSq = this.yre * this.yre + this.yim * this.yim) > infNormSq) {
            infNormSq = modSq;
        }
        if ((modSq = this.zre * this.zre + this.zim * this.zim) > infNormSq) {
            infNormSq = modSq;
        }
        return Math.sqrt(infNormSq);
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Complex3Vector(-this.xre, -this.xim, -this.yre, -this.yim, -this.zre, -this.zim);
    }

    @Override
    public AbstractComplexVector conjugate() {
        return new Complex3Vector(this.xre, -this.xim, this.yre, -this.yim, this.zre, -this.zim);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member vec) {
        if (vec instanceof AbstractComplexVector) {
            return this.add((AbstractComplexVector)vec);
        }
        if (vec instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)vec);
        }
        if (vec instanceof AbstractIntegerVector) {
            return this.add((AbstractIntegerVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector add(AbstractComplexVector vec) {
        if (vec.N == 3) {
            return new Complex3Vector(this.xre + vec.getComponent(0).real(), this.xim + vec.getComponent(0).imag(), this.yre + vec.getComponent(1).real(), this.yim + vec.getComponent(1).imag(), this.zre + vec.getComponent(2).real(), this.zim + vec.getComponent(2).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractDoubleVector vec) {
        if (vec.N == 3) {
            return new Complex3Vector(this.xre + vec.getComponent(0), this.xim, this.yre + vec.getComponent(1), this.yim, this.zre + vec.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractIntegerVector vec) {
        if (vec.N == 3) {
            return new Complex3Vector(this.xre + (double)vec.getComponent(0), this.xim, this.yre + (double)vec.getComponent(1), this.yim, this.zre + (double)vec.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member vec) {
        if (vec instanceof AbstractComplexVector) {
            return this.subtract((AbstractComplexVector)vec);
        }
        if (vec instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)vec);
        }
        if (vec instanceof AbstractIntegerVector) {
            return this.subtract((AbstractIntegerVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector subtract(AbstractComplexVector vec) {
        if (vec.N == 3) {
            return new Complex3Vector(this.xre - vec.getComponent(0).real(), this.xim - vec.getComponent(0).imag(), this.yre - vec.getComponent(1).real(), this.yim - vec.getComponent(1).imag(), this.zre - vec.getComponent(2).real(), this.zim - vec.getComponent(2).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractDoubleVector vec) {
        if (vec.N == 3) {
            return new Complex3Vector(this.xre - vec.getComponent(0), this.xim, this.yre - vec.getComponent(1), this.yim, this.zre - vec.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractIntegerVector vec) {
        if (vec.N == 3) {
            return new Complex3Vector(this.xre - (double)vec.getComponent(0), this.xim, this.yre - (double)vec.getComponent(1), this.yim, this.zre - (double)vec.getComponent(2), this.zim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof Complex) {
            return this.scalarMultiply((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        return new Complex3Vector(this.xre * real - this.xim * imag, this.xre * imag + this.xim * real, this.yre * real - this.yim * imag, this.yre * imag + this.yim * real, this.zre * real - this.zim * imag, this.zre * imag + this.zim * real);
    }

    @Override
    public AbstractComplexVector scalarMultiply(double k) {
        return new Complex3Vector(k * this.xre, k * this.xim, k * this.yre, k * this.yim, k * this.zre, k * this.zim);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof Complex) {
            return this.scalarDivide((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector scalarDivide(Complex z) {
        double real = z.real();
        double imag = z.imag();
        if (Math.abs(real) < Math.abs(imag)) {
            double a = real / imag;
            double denom = real * a + imag;
            return new Complex3Vector((this.xre * a + this.xim) / denom, (this.xim * a - this.xre) / denom, (this.yre * a + this.yim) / denom, (this.yim * a - this.yre) / denom, (this.zre * a + this.zim) / denom, (this.zim * a - this.zre) / denom);
        }
        double a = imag / real;
        double denom = real + imag * a;
        return new Complex3Vector((this.xre + this.xim * a) / denom, (this.xim - this.xre * a) / denom, (this.yre + this.yim * a) / denom, (this.yim - this.yre * a) / denom, (this.zre + this.zim * a) / denom, (this.zim - this.zre * a) / denom);
    }

    @Override
    public AbstractComplexVector scalarDivide(double k) {
        return new Complex3Vector(this.xre / k, this.xim / k, this.yre / k, this.yim / k, this.zre / k, this.zim / k);
    }

    @Override
    public Complex scalarProduct(HilbertSpace.Member vec) {
        if (vec instanceof AbstractComplexVector) {
            return this.scalarProduct((AbstractComplexVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public Complex scalarProduct(AbstractComplexVector vec) {
        if (vec instanceof Complex3Vector) {
            return this.scalarProduct((Complex3Vector)vec);
        }
        if (vec.N == 3) {
            return new Complex(this.xre * vec.getComponent(0).real() + this.xim * vec.getComponent(0).imag() + this.yre * vec.getComponent(1).real() + this.yim * vec.getComponent(1).imag() + this.zre * vec.getComponent(2).real() + this.zim * vec.getComponent(2).imag(), this.xim * vec.getComponent(0).real() - this.xre * vec.getComponent(0).imag() + this.yim * vec.getComponent(1).real() - this.yre * vec.getComponent(1).imag() + this.zim * vec.getComponent(2).real() - this.zre * vec.getComponent(2).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Complex scalarProduct(Complex3Vector vec) {
        return new Complex(this.xre * vec.xre + this.xim * vec.xim + this.yre * vec.yre + this.yim * vec.yim + this.zre * vec.zre + this.zim * vec.zim, this.xim * vec.xre - this.xre * vec.xim + this.yim * vec.yre - this.yre * vec.yim + this.zim * vec.zre - this.zre * vec.zim);
    }

    public Complex3Vector multiply(Complex3Vector vec) {
        return new Complex3Vector(this.yre * vec.zre - this.yim * vec.zim - this.zre * vec.yre + this.zim * vec.yim, this.yre * vec.zim + this.yim * vec.zre - this.zre * vec.yim - this.zim * vec.yre, this.zre * vec.xre - this.zim * vec.xim - this.xre * vec.zre + this.xim * vec.zim, this.zre * vec.xim + this.zim * vec.xre - this.xre * vec.zim - this.xim * vec.zre, this.xre * vec.yre - this.xim * vec.yim - this.yre * vec.xre + this.yim * vec.xim, this.xre * vec.yim + this.xim * vec.yre - this.yre * vec.xim - this.yim * vec.xre);
    }

    @Override
    public AbstractComplexVector mapComponents(ComplexMapping mapping) {
        return new Complex3Vector(mapping.map(this.xre, this.xim), mapping.map(this.yre, this.yim), mapping.map(this.zre, this.zim));
    }
}

