/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.GlobalSettings;
import jsci.maths.ExtraMath;
import jsci.maths.Mapping;
import jsci.maths.algebras.BanachSpace;
import jsci.maths.vectors.MathVector;

public abstract class AbstractDoubleVector
extends MathVector
implements BanachSpace.Member {
    protected AbstractDoubleVector(int dim) {
        super(dim);
    }

    public final boolean equals(Object obj) {
        return this.equals(obj, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof AbstractDoubleVector) {
            AbstractDoubleVector vec = (AbstractDoubleVector)obj;
            return this.dimension() == vec.dimension() && this.subtract(vec).norm() <= tol;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(8 * this.N);
        for (i = 0; i < this.N - 1; ++i) {
            buf.append(this.getComponent(i));
            buf.append(',');
        }
        buf.append(this.getComponent(i));
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract double getComponent(int var1);

    public abstract void setComponent(int var1, double var2);

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double norm(int n) {
        double answer = Math.pow(Math.abs(this.getComponent(0)), n);
        for (int i = 1; i < this.N; ++i) {
            answer += Math.pow(Math.abs(this.getComponent(i)), n);
        }
        return Math.pow(answer, 1.0 / (double)n);
    }

    @Override
    public double norm() {
        double answer = this.getComponent(0);
        for (int i = 1; i < this.N; ++i) {
            answer = ExtraMath.hypot(answer, this.getComponent(i));
        }
        return answer;
    }

    public double infNorm() {
        double infNorm = Math.abs(this.getComponent(0));
        for (int i = 1; i < this.N; ++i) {
            double abs = Math.abs(this.getComponent(i));
            if (!(abs > infNorm)) continue;
            infNorm = abs;
        }
        return infNorm;
    }

    public double mass() {
        double mass = 0.0;
        for (int i = 1; i < this.N; ++i) {
            mass += this.getComponent(i);
        }
        return mass;
    }

    public abstract AbstractDoubleVector add(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector subtract(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector scalarMultiply(double var1);

    public abstract AbstractDoubleVector scalarDivide(double var1);

    public AbstractDoubleVector normalize() {
        return this.scalarDivide(this.norm());
    }

    public abstract double scalarProduct(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector mapComponents(Mapping var1);
}

