/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import jsci.maths.groups.AbelianGroup;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Variable;

class Negative
extends Expression {
    private final Expression arg;

    public Negative(Expression arg) {
        this.arg = arg;
    }

    public String toString() {
        String r = "-";
        r = this.arg.getPriority() < this.getPriority() ? r + "(" + this.arg + ")" : r + "" + this.arg;
        return r;
    }

    @Override
    public Expression differentiate(Variable x) {
        return new Negative(this.arg.differentiate(x));
    }

    @Override
    public Expression evaluate() {
        Expression a = this.arg.evaluate();
        if (a instanceof Constant) {
            AbelianGroup.Member p = (AbelianGroup.Member)((Constant)a).getValue();
            return new Constant(p.negate());
        }
        return new Negative(a);
    }

    @Override
    protected int getPriority() {
        return -1;
    }

    @Override
    public Object getSet() {
        return this.arg.getSet();
    }
}

