/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.maths.MathDouble;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.polynomials.RealPolynomial;

public class RealPolynomialRing
implements Ring {
    private static final RealPolynomial ZERO = new RealPolynomial(new double[]{0.0});
    private static final RealPolynomial ONE = new RealPolynomial(new double[]{1.0});
    private static final RealPolynomialRing _instance = new RealPolynomialRing();

    protected RealPolynomialRing() {
    }

    public static final RealPolynomialRing getInstance() {
        return _instance;
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        if (a instanceof RealPolynomial && b instanceof RealPolynomial) {
            RealPolynomial p1 = (RealPolynomial)a;
            RealPolynomial p2 = (RealPolynomial)b;
            return p1.add(p2).equals(ZERO);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public boolean isOne(Ring.Member r) {
        if (r instanceof RealPolynomial) {
            return ((RealPolynomial)r).isOne();
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public boolean isZero(AbelianGroup.Member g) {
        if (g instanceof RealPolynomial) {
            return ((RealPolynomial)g).isZero();
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public Ring.Member one() {
        return ONE;
    }

    @Override
    public AbelianGroup.Member zero() {
        return ZERO;
    }

    protected static double[] toDouble(Field.Member[] f) {
        if (f == null) {
            return null;
        }
        int dim = f.length;
        double[] d = new double[dim];
        for (int k = 0; k < dim; ++k) {
            if (!(f[k] instanceof MathDouble)) {
                throw new IllegalArgumentException("Expected MathDouble. Got (" + k + ") " + f[k]);
            }
            d[k] = ((MathDouble)f[k]).value();
        }
        return d;
    }

    protected static MathDouble[] toMathDouble(double[] d) {
        if (d == null) {
            return null;
        }
        int dim = d.length;
        MathDouble[] s = new MathDouble[dim];
        for (int k = 0; k < dim; ++k) {
            s[k] = new MathDouble(d[k]);
        }
        return s;
    }
}

