/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.maths.AbstractMath;
import jsci.maths.Complex;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.polynomials.ComplexLagrangeBasis;
import jsci.maths.polynomials.ComplexPolynomial;
import jsci.maths.polynomials.Polynomial;
import jsci.maths.polynomials.RealLagrangeBasis;
import jsci.maths.polynomials.RealPolynomial;

public final class PolynomialMath
extends AbstractMath {
    private PolynomialMath() {
    }

    public static AbstractDoubleSquareMatrix toCompanionMatrix(RealPolynomial p) {
        RealPolynomial np = PolynomialMath.normalize(p);
        int n = np.degree();
        if (n < 1) {
            throw new IllegalArgumentException("Cannot get a companion matrix for a constant factor");
        }
        DoubleSquareMatrix dsm = new DoubleSquareMatrix(n);
        for (int k = 0; k < n - 1; ++k) {
            ((AbstractDoubleMatrix)dsm).setElement(k + 1, k, 1.0);
            ((AbstractDoubleMatrix)dsm).setElement(k, n - 1, np.getCoefficientAsDouble(k));
        }
        ((AbstractDoubleMatrix)dsm).setElement(n - 1, n - 1, np.getCoefficientAsDouble(n - 1));
        return dsm;
    }

    public static AbstractComplexSquareMatrix toCompanionMatrix(ComplexPolynomial p) {
        ComplexPolynomial np = PolynomialMath.normalize(p);
        int n = np.degree();
        if (n < 1) {
            throw new IllegalArgumentException("Cannot get a companion matrix for a constant factor");
        }
        ComplexSquareMatrix csm = new ComplexSquareMatrix(n);
        for (int k = 0; k < n - 1; ++k) {
            ((AbstractComplexMatrix)csm).setElement(k + 1, k, 1.0, 0.0);
            ((AbstractComplexMatrix)csm).setElement(k, n - 1, np.getCoefficientAsComplex(k));
        }
        ((AbstractComplexMatrix)csm).setElement(n - 1, n - 1, np.getCoefficientAsComplex(n - 1));
        return csm;
    }

    public static Complex[] findRoots(RealPolynomial p) {
        AbstractDoubleSquareMatrix matrix = PolynomialMath.toCompanionMatrix(p);
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static int maxDegree(Polynomial p1, Polynomial p2) {
        return Math.max(p1.degree(), p2.degree());
    }

    public static int minDegree(Polynomial p1, Polynomial p2) {
        return Math.min(p1.degree(), p2.degree());
    }

    public static double evalPolynomial(RealPolynomial p, double t) {
        int n = p.degree();
        double r = p.getCoefficientAsDouble(n);
        for (int i = n - 1; i >= 0; --i) {
            r = p.getCoefficientAsDouble(i) + r * t;
        }
        return r;
    }

    public static Complex evalPolynomial(ComplexPolynomial p, Complex t) {
        int n = p.degree();
        Complex r = p.getCoefficientAsComplex(n);
        for (int i = n - 1; i >= 0; --i) {
            r = p.getCoefficientAsComplex(i).add(r.multiply(t));
        }
        return r;
    }

    public static RealPolynomial interpolateLagrange(double[][] samplingPoints) {
        RealLagrangeBasis r = new RealLagrangeBasis(samplingPoints[0]);
        return r.superposition(samplingPoints[1]);
    }

    public static ComplexPolynomial interpolateLagrange(Complex[][] samplingPoints) {
        ComplexLagrangeBasis r = new ComplexLagrangeBasis(samplingPoints[0]);
        return r.superposition(samplingPoints[1]);
    }

    public static RealPolynomial normalize(RealPolynomial p) {
        int n = p.degree();
        double c = p.getCoefficientAsDouble(n);
        double[] m = new double[n + 1];
        m[n] = 1.0;
        for (int i = 0; i < n; ++i) {
            m[i] = p.getCoefficientAsDouble(i) / c;
        }
        return new RealPolynomial(m);
    }

    public static ComplexPolynomial normalize(ComplexPolynomial p) {
        int n = p.degree();
        Complex c = p.getCoefficientAsComplex(n);
        Complex[] m = new Complex[n + 1];
        m[n] = Complex.ONE;
        for (int i = 0; i < n; ++i) {
            m[i] = p.getCoefficientAsComplex(i).divide(c);
        }
        return new ComplexPolynomial(m);
    }

    public static ComplexPolynomial toComplex(Polynomial p) {
        if (p instanceof ComplexPolynomial) {
            return (ComplexPolynomial)p;
        }
        if (p instanceof RealPolynomial) {
            double[] d = ((RealPolynomial)p).getCoefficientsAsDoubles();
            Complex[] c = new Complex[d.length];
            for (int k = 0; k < d.length; ++k) {
                c[k] = new Complex(d[k], 0.0);
            }
            return new ComplexPolynomial(c);
        }
        throw new IllegalArgumentException("Polynomial class not recognised by this method.");
    }
}

