/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.GlobalSettings;
import jsci.maths.Complex;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.polynomials.ComplexPolynomialRing;
import jsci.maths.polynomials.Polynomial;
import jsci.maths.polynomials.PolynomialMath;

public class ComplexPolynomial
implements Polynomial {
    private Complex[] _coeff;

    public ComplexPolynomial(Complex[] coeff) {
        if (coeff == null) {
            throw new NullPointerException("Coefficients cannot be null");
        }
        this._coeff = ComplexPolynomial.normalise(coeff);
    }

    private static Complex[] normalise(Complex[] c) {
        int i;
        for (i = c.length - 1; i >= 0 && c[i].norm() <= 2.0 * GlobalSettings.ZERO_TOL; --i) {
        }
        if (i < 0) {
            return new Complex[]{Complex.ZERO};
        }
        if (i < c.length - 1) {
            Complex[] arr = new Complex[i + 1];
            System.arraycopy(c, 0, arr, 0, arr.length);
            return arr;
        }
        return c;
    }

    public ComplexPolynomial(Field.Member[] f) {
        this._coeff = ComplexPolynomial.normalise(ComplexPolynomialRing.toComplex(f));
    }

    @Override
    public Field.Member getCoefficient(int n) {
        return this.getCoefficientAsComplex(n);
    }

    public Complex getCoefficientAsComplex(int n) {
        if (n >= this._coeff.length) {
            return Complex.ZERO;
        }
        return this._coeff[n];
    }

    @Override
    public Field.Member[] getCoefficients() {
        return this.getCoefficientsAsComplexes();
    }

    public Complex[] getCoefficientsAsComplexes() {
        return this._coeff;
    }

    public Complex map(Complex z) {
        return PolynomialMath.evalPolynomial(this, z);
    }

    public Complex map(double x, double y) {
        return this.map(new Complex(x, y));
    }

    @Override
    public int degree() {
        return this._coeff.length - 1;
    }

    @Override
    public Object getSet() {
        return ComplexPolynomialRing.getInstance();
    }

    public boolean isZero() {
        for (int k = 0; k < this._coeff.length; ++k) {
            if (!(this._coeff[k].norm() > GlobalSettings.ZERO_TOL * 2.0)) continue;
            return false;
        }
        return true;
    }

    public boolean isOne() {
        if (this._coeff[0].subtract(Complex.ONE).norm() > GlobalSettings.ZERO_TOL * 2.0) {
            return false;
        }
        for (int k = 1; k < this._coeff.length; ++k) {
            if (!(this._coeff[k].norm() > 2.0 * GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member g) {
        Complex[] c;
        ComplexPolynomial result = null;
        if (g instanceof ComplexPolynomial) {
            ComplexPolynomial p = (ComplexPolynomial)g;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            c = new Complex[maxgrade + 1];
            for (int k = 0; k < c.length; ++k) {
                c[k] = this.getCoefficientAsComplex(k).add(p.getCoefficientAsComplex(k));
            }
        } else {
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
        result = new ComplexPolynomial(c);
        return result;
    }

    @Override
    public Polynomial scalarDivide(Field.Member f) {
        if (f instanceof Complex) {
            return this.scalarDivide((Complex)f);
        }
        if (f instanceof Number) {
            return this.scalarDivide(((Number)((Object)f)).doubleValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexPolynomial scalarDivide(Complex a) {
        Complex[] c = new Complex[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = this._coeff[k].divide(a);
        }
        return new ComplexPolynomial(c);
    }

    public ComplexPolynomial scalarDivide(double a) {
        Complex[] c = new Complex[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = this._coeff[k].divide(a);
        }
        return new ComplexPolynomial(c);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ComplexPolynomial) {
            ComplexPolynomial p = (ComplexPolynomial)o;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            for (int k = 0; k <= maxgrade; ++k) {
                if (!(p.getCoefficientAsComplex(k).subtract(this.getCoefficientAsComplex(k)).norm() > 2.0 * GlobalSettings.ZERO_TOL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int res = 0;
        for (int k = 0; k < this._coeff.length; ++k) {
            res += (int)(this._coeff[k].norm() * 10.0);
        }
        return res;
    }

    @Override
    public Polynomial scalarMultiply(Field.Member f) {
        if (f instanceof Number) {
            double a = ((Number)((Object)f)).doubleValue();
            return this.scalarMultiply(a);
        }
        if (f instanceof Complex) {
            return this.scalarMultiply((Complex)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexPolynomial scalarMultiply(double a) {
        Complex[] c = new Complex[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = this._coeff[k].multiply(a);
        }
        return new ComplexPolynomial(c);
    }

    public ComplexPolynomial scalarMultiply(Complex a) {
        Complex[] c = new Complex[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = this._coeff[k].multiply(a);
        }
        return new ComplexPolynomial(c);
    }

    @Override
    public Ring.Member multiply(Ring.Member r) {
        if (r instanceof ComplexPolynomial) {
            int k;
            ComplexPolynomial p = (ComplexPolynomial)r;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            int mingrade = PolynomialMath.minDegree(this, p);
            int destgrade = maxgrade + mingrade;
            Complex[] n = new Complex[destgrade + 1];
            for (k = 0; k < n.length; ++k) {
                n[k] = Complex.ZERO;
            }
            for (k = 0; k < this._coeff.length; ++k) {
                Complex tis = this._coeff[k];
                for (int j = 0; j < p._coeff.length; ++j) {
                    Complex tat = p._coeff[j];
                    n[k + j] = n[k + j].add(tis.multiply(tat));
                }
            }
            return new ComplexPolynomial(n);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbelianGroup.Member negate() {
        Complex[] c = new Complex[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = (Complex)this._coeff[k].negate();
        }
        return new ComplexPolynomial(c);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member g) {
        if (g instanceof ComplexPolynomial) {
            ComplexPolynomial p = (ComplexPolynomial)g;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            Complex[] c = new Complex[maxgrade + 1];
            for (int k = 0; k < c.length; ++k) {
                c[k] = this.getCoefficientAsComplex(k).subtract(p.getCoefficientAsComplex(k));
            }
            return new ComplexPolynomial(c);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("P(z) = ");
        for (int k = this.degree(); k > 0; --k) {
            sb.append(this._coeff[k]).append("z^").append(k).append(" + ");
        }
        sb.append(this._coeff[0]);
        return sb.toString();
    }
}

