/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.matrices.DoubleMatrix;
import jsci.maths.matrices.IntegerMatrix;
import jsci.maths.matrices.IntegerMatrixAlgebra;
import jsci.maths.matrices.IntegerSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.IntegerVector;

public abstract class AbstractIntegerMatrix
extends Matrix {
    protected AbstractIntegerMatrix(int rows, int cols) {
        super(rows, cols);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof AbstractIntegerMatrix) {
            return this.equals((AbstractIntegerMatrix)obj);
        }
        return false;
    }

    public final boolean equals(AbstractIntegerMatrix m) {
        return this.equals(m, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(AbstractIntegerMatrix m, double tol) {
        if (m != null && this.numRows == m.rows() && this.numCols == m.columns()) {
            int sumSqr = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    int delta = this.getElement(i, j) - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return (double)sumSqr <= tol * tol;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.getElement(i, j);
            }
        }
        return new DoubleMatrix(ans);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix cm = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                cm.setElement(i, j, this.getElement(i, j), 0.0);
            }
        }
        return cm;
    }

    public abstract int getElement(int var1, int var2);

    public abstract void setElement(int var1, int var2, int var3);

    @Override
    public final Object getSet() {
        return IntegerMatrixAlgebra.get(this.numRows, this.numCols);
    }

    public int infNorm() {
        int result = 0;
        for (int i = 0; i < this.numRows; ++i) {
            int tmpResult = 0;
            for (int j = 0; j < this.numCols; ++j) {
                tmpResult += Math.abs(this.getElement(i, j));
            }
            if (tmpResult <= result) continue;
            result = tmpResult;
        }
        return result;
    }

    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                result = ExtraMath.hypot(result, this.getElement(i, j));
            }
        }
        return result;
    }

    @Override
    public AbelianGroup.Member negate() {
        int[][] array = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = -this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = -this.getElement(i, j);
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public final AbelianGroup.Member add(AbelianGroup.Member m) {
        if (m instanceof AbstractIntegerMatrix) {
            return this.add((AbstractIntegerMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix add(AbstractIntegerMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) + m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) + m.getElement(i, j);
                }
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final AbelianGroup.Member subtract(AbelianGroup.Member m) {
        if (m instanceof AbstractIntegerMatrix) {
            return this.subtract((AbstractIntegerMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix subtract(AbstractIntegerMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int[][] array = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.getElement(i, 0) - m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = this.getElement(i, j) - m.getElement(i, j);
                }
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof Number) {
            return this.scalarMultiply(((Number)((Object)x)).intValue());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix scalarMultiply(int x) {
        int[][] array = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = x * this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = x * this.getElement(i, j);
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public final VectorSpace.Member scalarDivide(Field.Member x) {
        throw new UnsupportedOperationException("Not an algebra");
    }

    public int scalarProduct(AbstractIntegerMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int ans = 0;
            for (int i = 0; i < this.numRows; ++i) {
                ans += this.getElement(i, 0) * m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    ans += this.getElement(i, j) * m.getElement(i, j);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector v) {
        if (this.numCols == v.dimension()) {
            int[] array = new int[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                array[i] = this.getElement(i, 0) * v.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    array[n] = array[n] + this.getElement(i, j) * v.getComponent(j);
                }
            }
            return new IntegerVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public final Ring.Member multiply(Ring.Member m) {
        if (m instanceof AbstractIntegerMatrix) {
            return this.multiply((AbstractIntegerMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerMatrix multiply(AbstractIntegerMatrix m) {
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            int[][] array = new int[this.numRows][mColumns];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < mColumns; ++k) {
                    array[j][k] = this.getElement(j, 0) * m.getElement(0, k);
                    for (int n = 1; n < this.numCols; ++n) {
                        int[] nArray = array[j];
                        int n2 = k;
                        nArray[n2] = nArray[n2] + this.getElement(j, n) * m.getElement(n, k);
                    }
                }
            }
            if (this.numRows == mColumns) {
                return new IntegerSquareMatrix(array);
            }
            return new IntegerMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractIntegerMatrix directSum(AbstractIntegerMatrix m) {
        int j;
        int i;
        int[][] array = new int[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                array[i][j] = this.getElement(i, j);
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                array[i + this.numRows][j + this.numCols] = m.getElement(i, j);
            }
        }
        return new IntegerMatrix(array);
    }

    public AbstractIntegerMatrix tensor(AbstractIntegerMatrix m) {
        int[][] array = new int[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        array[i * m.numRows + k][j * m.numCols + l] = this.getElement(i, j) * m.getElement(k, l);
                    }
                    ++j;
                }
            }
        }
        return new IntegerMatrix(array);
    }

    @Override
    public Matrix transpose() {
        int[][] array = new int[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[0][i] = this.getElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                array[j][i] = this.getElement(i, j);
            }
        }
        return new IntegerMatrix(array);
    }
}

