/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.groups;

import jsci.maths.Complex;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.matrices.ComplexDiagonalMatrix;
import jsci.maths.vectors.AbstractDoubleVector;

public class LieGroup {
    private AbstractComplexSquareMatrix[] generators;
    private AbstractComplexSquareMatrix identityMatrix;

    public LieGroup(AbstractComplexSquareMatrix[] gens) {
        this.generators = gens;
        this.identityMatrix = ComplexDiagonalMatrix.identity(this.generators[0].rows());
    }

    public final int dimension() {
        return this.generators.length;
    }

    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector v) {
        if (this.generators.length != v.dimension()) {
            throw new IllegalArgumentException("The vector should match the generators.");
        }
        AbstractComplexMatrix phase = this.generators[0].scalarMultiply(v.getComponent(0));
        for (int i = 1; i < this.generators.length; ++i) {
            phase = phase.add(this.generators[i].scalarMultiply(v.getComponent(i)));
        }
        return (AbstractComplexSquareMatrix)this.identityMatrix.add(phase.scalarMultiply(Complex.I));
    }

    public AbstractComplexSquareMatrix identity() {
        return this.identityMatrix;
    }

    public final boolean isIdentity(AbstractComplexSquareMatrix a) {
        return this.identityMatrix.equals(a);
    }

    public final boolean isInverse(AbstractComplexSquareMatrix a, AbstractComplexSquareMatrix b) {
        return this.isIdentity(a.multiply(b));
    }
}

