/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.fields;

import jsci.maths.Complex;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public final class ComplexField
implements Field {
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex MINUS_ONE = new Complex(-1.0, 0.0);
    public static final Complex MINUS_I = new Complex(0.0, -1.0);
    public static final Complex HALF = new Complex(0.5, 0.0);
    public static final Complex MINUS_HALF = new Complex(-0.5, 0.0);
    public static final Complex HALF_I = new Complex(0.0, 0.5);
    public static final Complex MINUS_HALF_I = new Complex(0.0, -0.5);
    public static final Complex TWO = new Complex(2.0, 0.0);
    public static final Complex MINUS_TWO = new Complex(-2.0, 0.0);
    public static final Complex SQRT_HALF = new Complex(Math.sqrt(0.5), 0.0);
    public static final Complex SQRT_HALF_I = new Complex(0.0, Math.sqrt(0.5));
    public static final Complex MINUS_SQRT_HALF_I = new Complex(0.0, -Math.sqrt(0.5));
    public static final Complex PI = new Complex(Math.PI, 0.0);
    public static final Complex PI_I = new Complex(0.0, Math.PI);
    public static final Complex PI_2 = new Complex(1.5707963267948966, 0.0);
    public static final Complex MINUS_PI_2 = new Complex(-1.5707963267948966, 0.0);
    public static final Complex PI_2_I = new Complex(0.0, 1.5707963267948966);
    public static final Complex MINUS_PI_2_I = new Complex(0.0, -1.5707963267948966);
    private static final ComplexField _instance = new ComplexField();

    private ComplexField() {
    }

    public static final ComplexField getInstance() {
        return _instance;
    }

    @Override
    public AbelianGroup.Member zero() {
        return ZERO;
    }

    @Override
    public boolean isZero(AbelianGroup.Member g) {
        return ZERO.equals(g);
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return ZERO.equals(a.add(b));
    }

    @Override
    public Ring.Member one() {
        return ONE;
    }

    @Override
    public boolean isOne(Ring.Member r) {
        return ONE.equals(r);
    }

    @Override
    public boolean isInverse(Field.Member a, Field.Member b) {
        return ONE.equals(a.multiply(b));
    }
}

