/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.chaos;

import jsci.maths.Mapping;

public final class LogisticMap
implements Mapping {
    private final double r;
    public static final double R_2CYCLE = 3.0;
    public static final double R_4CYCLE = 1.0 + Math.sqrt(6.0);
    public static final double R_8CYCLE = 3.54409;
    public static final double R_16CYCLE = 3.564407;
    public static final double R_ACCUMULATION = 3.569945672;

    public LogisticMap(double rval) {
        this.r = rval;
    }

    @Override
    public double map(double x) {
        return this.r * x * (1.0 - x);
    }

    public double hausdorffDimension() {
        return 0.538;
    }

    public double iterate(int n, double x) {
        for (int i = 0; i < n; ++i) {
            x = this.map(x);
        }
        return x;
    }
}

