/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.categories;

import jsci.maths.ExtraMath;
import jsci.maths.MathInteger;
import jsci.maths.categories.Bifunctor;
import jsci.maths.categories.Category;
import jsci.maths.categories.Functor;
import jsci.maths.categories.Preorder;
import jsci.maths.categories.UndefinedCompositionException;

public final class Simplicial
implements Category {
    public final Bifunctor ADDITION = new Addition();

    @Override
    public Category.Morphism identity(Object a) {
        Preorder p = (Preorder)a;
        Integer[] id = new Integer[p.ordinal()];
        for (int i = 0; i < id.length; ++i) {
            id[i] = new Integer(i);
        }
        return new IncreasingMap(p, id);
    }

    @Override
    public Object cardinality(Object a) {
        return new MathInteger(((Preorder)a).ordinal());
    }

    @Override
    public Category.HomSet hom(Object a, Object b) {
        return new FunctionSet((Preorder)a, (Preorder)b);
    }

    public Object terminal() {
        return new Preorder(1);
    }

    public final class Addition
    implements Bifunctor {
        @Override
        public Object map(Object a, Object b) {
            return new Preorder(((Preorder)a).ordinal() + ((Preorder)b).ordinal());
        }

        @Override
        public Category.Morphism map(Category.Morphism m, Category.Morphism n) {
            int i;
            IncreasingMap im = (IncreasingMap)m;
            IncreasingMap in = (IncreasingMap)n;
            Preorder to = new Preorder(im.to.ordinal() + in.to.ordinal());
            Integer[] toObj = new Integer[im.out.length + in.out.length];
            for (i = 0; i < im.out.length; ++i) {
                toObj[i] = im.out[i];
            }
            while (i < toObj.length) {
                toObj[i] = in.out[i];
                ++i;
            }
            return new IncreasingMap(to, toObj);
        }
    }

    public final class DegeneracyMap
    extends IncreasingMap {
        private final int repeat;

        public DegeneracyMap(Preorder toObj, int i) {
            super(toObj, new Integer[toObj.ordinal() + 1]);
            this.repeat = i;
            for (i = 0; i <= this.repeat; ++i) {
                this.out[i] = new Integer(i);
            }
            while (i < this.out.length) {
                this.out[i] = new Integer(i - 1);
                ++i;
            }
        }
    }

    public final class FaceMap
    extends IncreasingMap {
        private final int skip;

        public FaceMap(Preorder toObj, int i) {
            super(toObj, new Integer[toObj.ordinal() - 1]);
            this.skip = i;
            for (i = 0; i < this.skip; ++i) {
                this.out[i] = new Integer(i);
            }
            while (i < this.out.length) {
                this.out[i] = new Integer(i + 1);
                ++i;
            }
        }
    }

    public class IncreasingMap
    implements Functor {
        protected final Preorder from;
        protected final Preorder to;
        protected final Integer[] out;

        public IncreasingMap(Preorder toObj, Integer[] toImg) {
            this.from = new Preorder(toImg.length);
            this.to = toObj;
            this.out = toImg;
        }

        @Override
        public Object domain() {
            return this.from;
        }

        @Override
        public Object codomain() {
            return this.to;
        }

        @Override
        public Object map(Object o) {
            return this.out[(Integer)o];
        }

        @Override
        public Category.Morphism map(Category.Morphism m) {
            return ((Preorder.RelationSet)this.to.hom((Object)this.map((Object)m.domain()), (Object)this.map((Object)m.codomain()))).morphism;
        }

        @Override
        public Category.Morphism compose(Category.Morphism m) {
            return this.compose((Functor)m);
        }

        @Override
        public Functor compose(Functor f) {
            if (f instanceof IncreasingMap) {
                IncreasingMap im = (IncreasingMap)f;
                if (this.to.equals(im.from)) {
                    Integer[] outImg = new Integer[this.out.length];
                    for (int i = 0; i < outImg.length; ++i) {
                        outImg[i] = (Integer)im.map(this.out[i]);
                    }
                    return new IncreasingMap(im.to, outImg);
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not an IncreasingMap.");
        }
    }

    public class FunctionSet
    implements Category.HomSet {
        private final Preorder from;
        private final Preorder to;

        public FunctionSet(Preorder a, Preorder b) {
            this.from = a;
            this.to = b;
        }

        public int cardinality() {
            return ExtraMath.binomial(this.from.ordinal() + this.to.ordinal() - 1, this.from.ordinal());
        }
    }
}

