/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.analysis.Cosine;
import jsci.maths.analysis.RealFunction;

public class Sine
extends RealFunction {
    private final double A;
    private final double w;
    private final double k;

    public Sine() {
        this(1.0, 1.0, 0.0);
    }

    public Sine(double A, double w, double k) {
        this.A = A;
        this.w = w;
        this.k = k;
    }

    @Override
    public double map(double x) {
        return this.A * Math.sin(this.w * x + this.k);
    }

    @Override
    public RealFunction differentiate() {
        return new Cosine(this.A * this.w, this.w, this.k);
    }
}

