/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;
import jsci.maths.ArrayMath;
import jsci.maths.Complex;

public final class WaveletMath
extends AbstractMath {
    private WaveletMath() {
    }

    public static Complex[] downsample(Complex[] filter, Complex[] data) {
        int loc = filter.length;
        int demiloc = Math.round((float)loc / 2.0f - 0.5f);
        int Nombre = data.length;
        int DemiNombre = Math.round((float)Nombre / 2.0f - 0.5f);
        Complex[] answer = new Complex[DemiNombre];
        for (int i = 0; i < DemiNombre; ++i) {
            answer[i] = Complex.ZERO;
            for (int j = Math.max(0, 2 * i - demiloc + 1); j < Math.min(Nombre, 2 * i + loc - demiloc + 1); ++j) {
                answer[i] = answer[i].add(data[j].multiply(filter[j - 2 * i + demiloc - 1]));
            }
        }
        return answer;
    }

    public static double[] downsample(double[] filter, double[] data) {
        int loc = filter.length;
        int demiloc = Math.round((float)loc / 2.0f - 0.5f);
        int Nombre = data.length;
        int DemiNombre = Math.round((float)Nombre / 2.0f - 0.5f);
        double[] answer = new double[DemiNombre];
        for (int i = 0; i < DemiNombre; ++i) {
            answer[i] = 0.0;
            for (int j = Math.max(0, 2 * i - demiloc + 1); j < Math.min(Nombre, 2 * i + loc - demiloc + 1); ++j) {
                int n = i;
                answer[n] = answer[n] + data[j] * filter[j - 2 * i + demiloc - 1];
            }
        }
        return answer;
    }

    public static Complex[] upsample(Complex[] data) {
        int Nombre = data.length;
        Complex[] answer = new Complex[2 * Nombre];
        for (int i = 0; i < Nombre; ++i) {
            answer[2 * i] = data[i];
            answer[2 * i + 1] = Complex.ZERO;
        }
        return answer;
    }

    public static double[] upsample(double[] data) {
        int Nombre = data.length;
        double[] answer = new double[2 * Nombre];
        for (int i = 0; i < Nombre; ++i) {
            answer[2 * i] = data[i];
            answer[2 * i + 1] = 0.0;
        }
        return answer;
    }

    public static Complex[] upsample(Complex[] filter, Complex[] data) {
        int loc = filter.length;
        int demiloc = Math.round((float)loc / 2.0f - 0.5f);
        int Nombre = data.length;
        Complex[] answer = new Complex[2 * Nombre];
        Complex[] tmp = new Complex[2 * Nombre];
        tmp = WaveletMath.upsample(data);
        for (int i = 0; i < 2 * Nombre; ++i) {
            answer[i] = Complex.ZERO;
            for (int j = Math.max(0, i - demiloc); j < Math.min(2 * Nombre, i + loc - demiloc); ++j) {
                answer[i] = answer[i].add(tmp[j].multiply(filter[i + loc - demiloc - j - 1]));
            }
        }
        return answer;
    }

    public static double[] upsample(double[] filter, double[] data) {
        int loc = filter.length;
        int demiloc = Math.round((float)loc / 2.0f - 0.5f);
        int Nombre = data.length;
        double[] answer = new double[2 * Nombre];
        double[] tmp = new double[2 * Nombre];
        tmp = WaveletMath.upsample(data);
        for (int i = 0; i < 2 * Nombre; ++i) {
            answer[i] = 0.0;
            for (int j = Math.max(0, i - demiloc); j < Math.min(2 * Nombre, i + loc - demiloc); ++j) {
                int n = i;
                answer[n] = answer[n] + tmp[j] * filter[i + loc - demiloc - j - 1];
            }
        }
        return answer;
    }

    public static double[] lowToHigh(double[] v) {
        double[] ans = ArrayMath.invert(v);
        int b = 1;
        for (int k = 0; k < ans.length; ++k) {
            ans[k] = (double)b * ans[k];
            b = -b;
        }
        return ans;
    }
}

