/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.fields.IntegerRing;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public final class MathInteger
extends Number
implements Comparable,
Ring.Member {
    private static final long serialVersionUID = 6893485894391864141L;
    private final int x;

    public MathInteger(int num) {
        this.x = num;
    }

    public MathInteger(String s) throws NumberFormatException {
        this.x = Integer.parseInt(s);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MathInteger) {
            return this.x == ((MathInteger)obj).value();
        }
        return false;
    }

    public int hashCode() {
        return this.x;
    }

    public int compareTo(Object obj) throws IllegalArgumentException {
        if (obj != null && obj instanceof MathInteger) {
            int objValue = ((MathInteger)obj).x;
            if (this.x == objValue) {
                return 0;
            }
            return this.x - objValue;
        }
        throw new IllegalArgumentException("Invalid object: " + obj.getClass());
    }

    public String toString() {
        return Integer.toString(this.x);
    }

    public int value() {
        return this.x;
    }

    @Override
    public int intValue() {
        return this.x;
    }

    @Override
    public long longValue() {
        return this.x;
    }

    @Override
    public float floatValue() {
        return this.x;
    }

    @Override
    public double doubleValue() {
        return this.x;
    }

    public boolean isEven() {
        return (this.x & 1) == 0;
    }

    public boolean isOdd() {
        return (this.x & 1) == 1;
    }

    @Override
    public Object getSet() {
        return IntegerRing.getInstance();
    }

    @Override
    public AbelianGroup.Member negate() {
        return new MathInteger(-this.x);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member n) {
        if (n instanceof MathInteger) {
            return this.add((MathInteger)n);
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathInteger add(MathInteger n) {
        return this.add(n.x);
    }

    public MathInteger add(int y) {
        return new MathInteger(this.x + y);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member n) {
        if (n instanceof MathInteger) {
            return this.subtract((MathInteger)n);
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathInteger subtract(MathInteger n) {
        return this.subtract(n.x);
    }

    public MathInteger subtract(int y) {
        return new MathInteger(this.x - y);
    }

    @Override
    public Ring.Member multiply(Ring.Member n) {
        if (n instanceof MathInteger) {
            return this.multiply((MathInteger)n);
        }
        throw new IllegalArgumentException("Member class not recognised by this method: " + n.getClass());
    }

    public MathInteger multiply(MathInteger n) {
        return this.multiply(n.x);
    }

    public MathInteger multiply(int y) {
        return new MathInteger(this.x * y);
    }

    public MathInteger pow(MathInteger n) {
        if (n.x == 0) {
            return IntegerRing.ONE;
        }
        int ans = this.x;
        for (int i = 1; i < n.x; ++i) {
            ans *= this.x;
        }
        return new MathInteger(ans);
    }
}

