/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.AbstractMath;

public final class CoordinateMath
extends AbstractMath {
    private CoordinateMath() {
    }

    public static double[] cartesianToPolar(double x, double y) {
        double[] rtheta = new double[2];
        double xAbs = Math.abs(x);
        double yAbs = Math.abs(y);
        rtheta[0] = xAbs == 0.0 && yAbs == 0.0 ? 0.0 : (xAbs < yAbs ? yAbs * Math.sqrt(1.0 + x / y * (x / y)) : xAbs * Math.sqrt(1.0 + y / x * (y / x)));
        rtheta[1] = Math.atan2(y, x);
        return rtheta;
    }

    public static double[] polarToCartesian(double r, double theta) {
        double[] xy = new double[]{r * Math.cos(theta), r * Math.sin(theta)};
        return xy;
    }

    public static double[] cartesianToSpherical(double x, double y, double z) {
        double[] rthetaphi;
        rthetaphi = new double[]{Math.sqrt(x * x + y * y + z * z), Math.acos(z / rthetaphi[0]), Math.atan2(y, x)};
        return rthetaphi;
    }

    public static double[] sphericalToCartesian(double r, double theta, double phi) {
        double[] xyz = new double[]{r * Math.sin(theta) * Math.cos(phi), r * Math.sin(theta) * Math.sin(phi), r * Math.cos(theta)};
        return xyz;
    }

    public static double[] cartesianToCylindrical(double x, double y, double z) {
        double[] rphih = new double[3];
        double[] rphi = CoordinateMath.cartesianToPolar(x, y);
        rphih[0] = rphi[0];
        rphih[1] = rphi[1];
        rphih[2] = z;
        return rphih;
    }

    public static double[] cylindricalToCartesian(double r, double phi, double h) {
        double[] xyz = new double[3];
        double[] xy = CoordinateMath.polarToCartesian(r, phi);
        xyz[0] = xy[0];
        xyz[1] = xy[1];
        xyz[2] = h;
        return xyz;
    }

    public static double[] cylindricalToSpherical(double r, double phi, double h) {
        double[] rthetaphi = new double[3];
        double[] rtheta = CoordinateMath.cartesianToPolar(h, r);
        rthetaphi[0] = rtheta[0];
        rthetaphi[1] = rtheta[1];
        rthetaphi[2] = phi;
        return rthetaphi;
    }

    public static double[] sphericalToCylindrical(double r, double theta, double phi) {
        double[] rphih = new double[3];
        double[] hr = CoordinateMath.polarToCartesian(r, theta);
        rphih[0] = hr[1];
        rphih[1] = phi;
        rphih[2] = hr[0];
        return rphih;
    }
}

