/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.GlobalSettings;
import jsci.maths.ExtraMath;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.CStarAlgebra;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.ComplexField;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public final class Complex
implements Field.Member,
CStarAlgebra.Member {
    private static final long serialVersionUID = 6561957920497208796L;
    private double re;
    private double im;
    private transient boolean isModCached = false;
    private transient double modCache;
    private transient boolean isArgCached = false;
    private transient double argCache;
    public static final Complex I = ComplexField.I;
    public static final Complex ONE = ComplexField.ONE;
    public static final Complex ZERO = ComplexField.ZERO;

    public Complex(double x, double y) {
        this.re = x;
        this.im = y;
    }

    public Complex(String s) throws NumberFormatException {
        int iPos = s.indexOf(105);
        if (iPos == -1) {
            this.re = Double.parseDouble(s);
            this.im = 0.0;
        } else {
            String imStr;
            int expPos;
            int signPos = Complex.indexOf(s, '+', '-', 1);
            if (signPos == (expPos = Complex.indexOf(s, 'E', 'e', 1)) + 1) {
                signPos = Complex.indexOf(s, '+', '-', signPos + 1);
            }
            if (signPos == -1) {
                this.re = 0.0;
                imStr = s;
            } else if (iPos < signPos) {
                imStr = s.substring(0, signPos);
                this.re = Double.parseDouble(s.substring(signPos));
            } else {
                this.re = Double.parseDouble(s.substring(0, signPos));
                imStr = s.substring(signPos);
            }
            if (imStr.endsWith("i")) {
                this.im = Double.parseDouble(imStr.substring(0, imStr.length() - 1));
            } else {
                char ch = imStr.charAt(0);
                if (ch == 'i') {
                    this.im = Double.parseDouble(imStr.substring(1));
                } else if ((ch == '+' || ch == '-') && imStr.charAt(1) == 'i') {
                    this.im = Double.parseDouble(imStr.substring(2));
                    this.im = ch == '+' ? this.im : -this.im;
                } else {
                    throw new NumberFormatException("The imaginary unit, 'i', is in an invalid position");
                }
            }
        }
    }

    private static int indexOf(String s, char a, char b, int start) {
        int aPos = s.indexOf(a, start);
        int bPos = s.indexOf(b, start);
        return aPos == -1 ? bPos : aPos;
    }

    public static Complex polar(double mod, double arg) {
        Complex z = new Complex(mod * Math.cos(arg), mod * Math.sin(arg));
        z.modCache = mod;
        z.isModCached = true;
        z.argCache = arg;
        z.isArgCached = true;
        return z;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object obj, double tol) {
        if (obj instanceof Complex) {
            Complex z = (Complex)obj;
            return this.equals(z.re, z.im, tol);
        }
        return false;
    }

    public boolean equals(double real, double imag) {
        return this.equals(real, imag, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(double real, double imag, double tol) {
        return Complex.mod(this.re - real, this.im - imag) <= tol;
    }

    public String toString() {
        return Complex.toString(this.re, this.im);
    }

    public static String toString(double real, double imag) {
        StringBuffer buf = new StringBuffer();
        buf.append(real);
        if (imag >= 0.0) {
            buf.append("+");
        }
        buf.append(imag);
        buf.append("i");
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.mod());
    }

    public boolean isZero() {
        return this.mod() <= GlobalSettings.ZERO_TOL;
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.im == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.im == Double.POSITIVE_INFINITY || this.im == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public double mod() {
        if (this.isModCached) {
            return this.modCache;
        }
        this.modCache = Complex.mod(this.re, this.im);
        this.isModCached = true;
        return this.modCache;
    }

    private static double mod(double real, double imag) {
        double reAbs = Math.abs(real);
        double imAbs = Math.abs(imag);
        if (reAbs == 0.0 && imAbs == 0.0) {
            return 0.0;
        }
        if (reAbs < imAbs) {
            return imAbs * Math.sqrt(1.0 + real / imag * (real / imag));
        }
        return reAbs * Math.sqrt(1.0 + imag / real * (imag / real));
    }

    public double modSqr() {
        return this.re * this.re + this.im * this.im;
    }

    public double arg() {
        if (this.isArgCached) {
            return this.argCache;
        }
        this.argCache = Complex.arg(this.re, this.im);
        this.isArgCached = true;
        return this.argCache;
    }

    private static double arg(double real, double imag) {
        return Math.atan2(imag, real);
    }

    @Override
    public double norm() {
        return this.mod();
    }

    @Override
    public Object getSet() {
        return ComplexField.getInstance();
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Complex(-this.re, -this.im);
    }

    @Override
    public Field.Member inverse() {
        double denominator;
        double imag;
        double real;
        if (Math.abs(this.re) < Math.abs(this.im)) {
            real = this.re / this.im;
            imag = -1.0;
            denominator = this.re * real + this.im;
        } else {
            real = 1.0;
            imag = -this.im / this.re;
            denominator = this.re - this.im * imag;
        }
        return new Complex(real / denominator, imag / denominator);
    }

    @Override
    public CStarAlgebra.Member involution() {
        return this.conjugate();
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member x) {
        if (x instanceof Complex) {
            return this.add((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.addReal(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.addReal(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex add(Complex z) {
        return new Complex(this.re + z.re, this.im + z.im);
    }

    public Complex addReal(double real) {
        return new Complex(this.re + real, this.im);
    }

    public Complex addImag(double imag) {
        return new Complex(this.re, this.im + imag);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member x) {
        if (x instanceof Complex) {
            return this.subtract((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.subtractReal(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.subtractReal(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex subtract(Complex z) {
        return new Complex(this.re - z.re, this.im - z.im);
    }

    public Complex subtractReal(double real) {
        return new Complex(this.re - real, this.im);
    }

    public Complex subtractImag(double imag) {
        return new Complex(this.re, this.im - imag);
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        return (Complex)this.multiply(x);
    }

    @Override
    public Ring.Member multiply(Ring.Member x) {
        if (x instanceof Complex) {
            return this.multiply((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.multiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.multiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex multiply(Complex z) {
        return new Complex(this.re * z.re - this.im * z.im, this.re * z.im + this.im * z.re);
    }

    public Complex multiply(double x) {
        return new Complex(x * this.re, x * this.im);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        return (Complex)this.divide(x);
    }

    @Override
    public Field.Member divide(Field.Member x) {
        if (x instanceof Complex) {
            return this.divide((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.divide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex divide(Complex z) {
        double imag;
        double real;
        double denominator;
        if (Math.abs(z.re) < Math.abs(z.im)) {
            double a = z.re / z.im;
            denominator = z.re * a + z.im;
            real = this.re * a + this.im;
            imag = this.im * a - this.re;
        } else {
            double a = z.im / z.re;
            denominator = z.re + z.im * a;
            real = this.re + this.im * a;
            imag = this.im - this.re * a;
        }
        return new Complex(real / denominator, imag / denominator);
    }

    public Complex divide(double x) {
        return new Complex(this.re / x, this.im / x);
    }

    public Complex pow(Complex z) {
        double thisMod = this.mod();
        double thisArg = this.arg();
        double r = Math.pow(thisMod, z.re) / Math.exp(thisArg * z.im);
        double a = thisArg * z.re + Math.log(thisMod) * z.im;
        return Complex.polar(r, a);
    }

    public Complex pow(double x) {
        return Complex.polar(Math.pow(this.mod(), x), this.arg() * x);
    }

    public Complex sqr() {
        return new Complex(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
    }

    public Complex sqrt() {
        return Complex.polar(Math.sqrt(this.mod()), this.arg() / 2.0);
    }

    private static Complex sqrt(double real, double imag) {
        return Complex.polar(Math.sqrt(Complex.mod(real, imag)), Complex.arg(real, imag) / 2.0);
    }

    public static Complex exp(Complex z) {
        return new Complex(Math.exp(z.re) * Math.cos(z.im), Math.exp(z.re) * Math.sin(z.im));
    }

    public static Complex log(Complex z) {
        return new Complex(Math.log(z.mod()), z.arg());
    }

    private static final Complex log(double real, double imag) {
        return new Complex(Math.log(Complex.mod(real, imag)), Complex.arg(real, imag));
    }

    private static final Complex log_2(double real, double imag) {
        return new Complex(Math.log(Complex.mod(real, imag)) / 2.0, Complex.arg(real, imag) / 2.0);
    }

    private static final Complex log_2I(double real, double imag) {
        return new Complex(Complex.arg(real, imag) / 2.0, -Math.log(Complex.mod(real, imag)) / 2.0);
    }

    private static final Complex log_2IplusPI_2(double real, double imag) {
        return new Complex((Complex.arg(real, imag) + Math.PI) / 2.0, -Math.log(Complex.mod(real, imag)) / 2.0);
    }

    public static Complex sin(Complex z) {
        return new Complex(Math.sin(z.re) * ExtraMath.cosh(z.im), Math.cos(z.re) * ExtraMath.sinh(z.im));
    }

    public static Complex cos(Complex z) {
        return new Complex(Math.cos(z.re) * ExtraMath.cosh(z.im), -Math.sin(z.re) * ExtraMath.sinh(z.im));
    }

    public static Complex tan(Complex z) {
        double sinRe = Math.sin(z.re);
        double cosRe = Math.cos(z.re);
        double sinhIm = ExtraMath.sinh(z.im);
        double coshIm = ExtraMath.cosh(z.im);
        double denom = cosRe * cosRe * coshIm * coshIm + sinRe * sinRe * sinhIm * sinhIm;
        return new Complex(sinRe * cosRe / denom, sinhIm * coshIm / denom);
    }

    public static Complex sinh(Complex z) {
        return new Complex(ExtraMath.sinh(z.re) * Math.cos(z.im), ExtraMath.cosh(z.re) * Math.sin(z.im));
    }

    public static Complex cosh(Complex z) {
        return new Complex(ExtraMath.cosh(z.re) * Math.cos(z.im), ExtraMath.sinh(z.re) * Math.sin(z.im));
    }

    public static Complex tanh(Complex z) {
        double sinhRe = ExtraMath.sinh(z.re);
        double coshRe = ExtraMath.cosh(z.re);
        double sinIm = Math.sin(z.im);
        double cosIm = Math.cos(z.im);
        double denom = coshRe * coshRe * cosIm * cosIm + sinhRe * sinhRe * sinIm * sinIm;
        return new Complex(sinhRe * coshRe / denom, sinIm * cosIm / denom);
    }

    public static Complex asin(Complex z) {
        if (z.equals(ONE)) {
            return ComplexField.PI_2;
        }
        if (z.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.MINUS_PI_2;
        }
        Complex root = Complex.sqrt(1.0 - z.re * z.re + z.im * z.im, -2.0 * z.re * z.im);
        double zModSqr = z.re * z.re + z.im * z.im;
        double rootModSqr = root.re * root.re + root.im * root.im;
        double denom = rootModSqr + zModSqr + 2.0 * (root.re * z.im - root.im * z.re);
        return Complex.log_2I((rootModSqr - zModSqr) / denom, 2.0 * (root.re * z.re + root.im * z.im) / denom);
    }

    public static Complex acos(Complex z) {
        if (z.equals(ONE)) {
            return ZERO;
        }
        if (z.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.PI;
        }
        Complex root = Complex.sqrt(1.0 - z.re * z.re + z.im * z.im, -2.0 * z.re * z.im);
        double zModSqr = z.re * z.re + z.im * z.im;
        double rootModSqr = root.re * root.re + root.im * root.im;
        double denom = rootModSqr + zModSqr + 2.0 * (root.im * z.re - root.re * z.im);
        return Complex.log_2IplusPI_2((rootModSqr - zModSqr) / denom, -2.0 * (root.re * z.re + root.im * z.im) / denom);
    }

    public static Complex atan(Complex z) {
        double modSqr = z.modSqr();
        double denom = 1.0 + modSqr + 2.0 * z.im;
        return Complex.log_2I((1.0 - modSqr) / denom, 2.0 * z.re / denom);
    }

    public static Complex asinh(Complex z) {
        if (z.equals(I)) {
            return ComplexField.PI_2_I;
        }
        if (z.equals(ComplexField.MINUS_I)) {
            return ComplexField.MINUS_PI_2_I;
        }
        Complex root = Complex.sqrt(z.re * z.re - z.im * z.im + 1.0, 2.0 * z.re * z.im);
        return Complex.log(z.re + root.re, z.im + root.im);
    }

    public static Complex acosh(Complex z) {
        if (z.equals(ONE)) {
            return ZERO;
        }
        if (z.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.PI_I;
        }
        Complex root = Complex.sqrt(z.re * z.re - z.im * z.im - 1.0, 2.0 * z.re * z.im);
        return Complex.log(z.re + root.re, z.im + root.im);
    }

    public static Complex atanh(Complex z) {
        double modSqr = z.modSqr();
        double denom = 1.0 + modSqr - 2.0 * z.re;
        return Complex.log_2((1.0 - modSqr) / denom, 2.0 * z.im / denom);
    }
}

