/*
 * Decompiled with CFR 0.152.
 */
package jsci.chemistry;

import jsci.chemistry.Element;
import jsci.chemistry.Molecule;
import jsci.physics.Particle;
import jsci.physics.particles.Electron;
import jsci.physics.particles.Lepton;
import jsci.physics.particles.Neutron;
import jsci.physics.particles.Nucleon;
import jsci.physics.particles.Proton;

public class Atom
extends Particle {
    private Lepton[] shell;
    private final int shellSize;
    private Nucleon[] nucleus;
    private final int nucleusSize;

    public Atom(Element e) {
        this.shellSize = e.getAtomicNumber();
        this.nucleusSize = e.getMassNumber();
    }

    public Nucleon[] getNucleus() {
        if (this.nucleus == null) {
            int i;
            this.nucleus = new Nucleon[this.nucleusSize];
            for (i = 0; i < this.shellSize; ++i) {
                this.nucleus[i] = new Proton();
            }
            while (i < this.nucleusSize) {
                this.nucleus[i] = new Neutron();
                ++i;
            }
        }
        return this.nucleus;
    }

    public Lepton[] getShell() {
        if (this.shell == null) {
            this.shell = new Lepton[this.shellSize];
            for (int i = 0; i < this.shellSize; ++i) {
                this.shell[i] = new Electron();
            }
        }
        return this.shell;
    }

    public Molecule bind(Atom a) {
        return new Molecule(this, a);
    }
}

