/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.media.j3d.J3dI18N;

public class J3DBuffer {
    private Buffer originalBuffer = null;
    private Buffer readonlyBuffer = null;
    Type bufferType = Type.NULL;

    public J3DBuffer() {
        this(null);
    }

    public J3DBuffer(Buffer buffer) {
        this.setBuffer(buffer);
    }

    public void setBuffer(Buffer buffer) {
        Type type = Type.NULL;
        boolean bl = false;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        if (buffer == null) {
            type = Type.NULL;
        } else if (buffer instanceof ByteBuffer) {
            type = Type.BYTE;
            bl = ((ByteBuffer)buffer).isDirect();
            byteOrder = ((ByteBuffer)buffer).order();
        } else if (buffer instanceof CharBuffer) {
            type = Type.CHAR;
            bl = ((CharBuffer)buffer).isDirect();
            byteOrder = ((CharBuffer)buffer).order();
        } else if (buffer instanceof ShortBuffer) {
            type = Type.SHORT;
            bl = ((ShortBuffer)buffer).isDirect();
            byteOrder = ((ShortBuffer)buffer).order();
        } else if (buffer instanceof IntBuffer) {
            type = Type.INT;
            bl = ((IntBuffer)buffer).isDirect();
            byteOrder = ((IntBuffer)buffer).order();
        } else if (buffer instanceof LongBuffer) {
            type = Type.LONG;
            bl = ((LongBuffer)buffer).isDirect();
            byteOrder = ((LongBuffer)buffer).order();
        } else if (buffer instanceof FloatBuffer) {
            type = Type.FLOAT;
            bl = ((FloatBuffer)buffer).isDirect();
            byteOrder = ((FloatBuffer)buffer).order();
        } else if (buffer instanceof DoubleBuffer) {
            type = Type.DOUBLE;
            bl = ((DoubleBuffer)buffer).isDirect();
            byteOrder = ((DoubleBuffer)buffer).order();
        } else {
            type = Type.UNKNOWN;
        }
        if (buffer != null) {
            if (!bl) {
                throw new IllegalArgumentException(J3dI18N.getString("J3DBuffer1"));
            }
            if (byteOrder != ByteOrder.nativeOrder()) {
                throw new IllegalArgumentException(J3dI18N.getString("J3DBuffer2"));
            }
        }
        this.bufferType = type;
        this.originalBuffer = buffer;
        switch (this.bufferType) {
            case BYTE: {
                ByteBuffer byteBuffer = ((ByteBuffer)buffer).asReadOnlyBuffer();
                byteBuffer.rewind();
                this.readonlyBuffer = byteBuffer;
                break;
            }
            case FLOAT: {
                FloatBuffer floatBuffer = ((FloatBuffer)buffer).asReadOnlyBuffer();
                floatBuffer.rewind();
                this.readonlyBuffer = floatBuffer;
                break;
            }
            case DOUBLE: {
                DoubleBuffer doubleBuffer = ((DoubleBuffer)buffer).asReadOnlyBuffer();
                doubleBuffer.rewind();
                this.readonlyBuffer = doubleBuffer;
                break;
            }
            default: {
                this.readonlyBuffer = null;
            }
        }
    }

    public Buffer getBuffer() {
        return this.originalBuffer;
    }

    Buffer getROBuffer() {
        return this.readonlyBuffer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        NULL,
        UNKNOWN,
        BYTE,
        CHAR,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

