/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvLightIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PvLight
extends PgJvxSrc
implements PvLightIf {
    protected static final int SHADING_SKY_CG = 11;
    protected static final int SHADING_SKY_CIE5 = 12;
    protected static final int SHADING_SKY_MOON = 13;
    protected static final int SHADING_SKY_BLEND = 14;
    protected PuDouble m_blend;
    protected double m_defBlend;
    protected boolean m_bSwitchedOn;
    protected boolean m_bHighlight;
    private PdColor m_color;
    protected int[] m_matCol;
    protected PuDouble m_intensity;
    protected double m_defIntensity;
    protected PdVector m_position;
    protected PdVector m_interest;
    protected PdVector m_direction;
    protected PdVector m_positionView;
    protected PdVector m_interestView;
    protected PdVector m_directionView;
    protected PuDouble m_angle;
    protected double m_defAngle;
    protected PuDouble m_corona;
    protected double m_defCorona;
    protected PuDouble m_falloff;
    protected double m_defFalloff;
    protected PuDouble m_exponent;
    protected double m_defExponent;
    protected PvDisplayIf m_display;
    protected int m_lightType;
    protected int m_reference;
    protected int m_shading;
    protected static final String[] LIGHT_TYPE = new String[]{PsConfig.getMessage(24170), PsConfig.getMessage(24171), PsConfig.getMessage(24172), PsConfig.getMessage(24173), PsConfig.getMessage(24174), PsConfig.getMessage(24415), PsConfig.getMessage(24416), PsConfig.getMessage(24422), PsConfig.getMessage(24423), PsConfig.getMessage(24424), PsConfig.getMessage(24425)};

    public PvLight(PvDisplayIf pvDisplayIf, int n) {
        this(pvDisplayIf);
        this.setName(LIGHT_TYPE[n] + PsObject.getNumObjects());
        this.setLightType(n);
    }

    public PvLight(PvDisplayIf pvDisplayIf) {
        super(3);
        this.setType(32);
        this.setState(151, true);
        this.m_display = pvDisplayIf;
        this.m_reference = 0;
        this.m_lightType = 1;
        this.m_defIntensity = 0.8;
        this.m_defAngle = 20.0;
        this.m_defCorona = 15.0;
        this.m_defFalloff = 10.0;
        this.m_defExponent = 10.0;
        this.m_defBlend = 5.0;
        this.m_shading = 0;
        this.m_bHighlight = false;
        this.m_color = new PdColor(PsConfig.getMessage(24290), this);
        this.m_matCol = new int[3];
        this.m_position = new PdVector(3);
        this.m_interest = new PdVector(3);
        this.m_direction = new PdVector(3);
        this.m_positionView = new PdVector(3);
        this.m_interestView = new PdVector(3);
        this.m_directionView = new PdVector(3);
        this.m_intensity = new PuDouble(PsConfig.getMessage(24291), this);
        this.m_angle = new PuDouble(PsConfig.getMessage(24292), this);
        this.m_corona = new PuDouble(PsConfig.getMessage(24293), this);
        this.m_falloff = new PuDouble(PsConfig.getMessage(24294), this);
        this.m_exponent = new PuDouble(PsConfig.getMessage(24295), this);
        this.m_blend = new PuDouble(PsConfig.getMessage(24425), this);
        this.init();
    }

    public void init() {
        super.init();
        this.setVisible(false);
        this.setSwitchedOn(true);
        this.setNumVertices(2);
        this.m_vertex[0].setName(LIGHT_TYPE[this.m_lightType]);
        this.m_vertex[1].setName(PsConfig.getMessage(24227));
        this.setPosition(0.0, -5.0, 5.0);
        this.setInterest(0.0, 0.0, 0.0);
        this.showVertices(true);
        this.setGlobalVertexSize(6.0);
        this.setNumPolygons(1);
        this.setDimOfPolygons(2);
        this.setPolygon(0, new PiVector(0, 1));
        this.showPolygons(true);
        this.showPolygonEndArrow(true);
        this.setGlobalPolygonSize(4.0);
        this.m_intensity.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_intensity.setDefValue(this.m_defIntensity);
        this.m_intensity.init();
        this.m_angle.setDefBounds(0.0, 90.0, 0.1, 1.0);
        this.m_angle.setDefValue(this.m_defAngle);
        this.m_angle.init();
        this.m_corona.setDefBounds(0.0, 90.0, 0.1, 1.0);
        this.m_corona.setDefValue(this.m_defCorona);
        this.m_corona.init();
        this.m_falloff.setDefBounds(0.0, 100.0, 0.1, 1.0);
        this.m_falloff.setDefValue(this.m_defFalloff);
        this.m_falloff.init();
        this.m_exponent.setDefBounds(0.0, 50.0, 0.1, 1.0);
        this.m_exponent.setDefValue(this.m_defFalloff);
        this.m_exponent.init();
        this.m_blend.setDefBounds(0.0, 20.0, 0.1, 1.0);
        this.m_blend.setDefValue(this.m_defBlend);
        this.m_blend.init();
        this.setColor(Color.white);
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == this.m_color) {
            this.setGlobalVertexColor(this.m_color.getColor());
            return super.update(null);
        }
        return super.update(object);
    }

    public Object clone() {
        PvLight pvLight = (PvLight)super.clone();
        if (pvLight == null) {
            return null;
        }
        pvLight.m_color = (PdColor)this.m_color.clone();
        pvLight.m_color.setParent(pvLight);
        if (this.m_matCol != null) {
            pvLight.m_matCol = (int[])this.m_matCol.clone();
        }
        pvLight.m_position = (PdVector)this.m_position.clone();
        pvLight.m_interest = (PdVector)this.m_interest.clone();
        pvLight.m_direction = (PdVector)this.m_direction.clone();
        pvLight.m_positionView = (PdVector)this.m_positionView.clone();
        pvLight.m_interestView = (PdVector)this.m_interestView.clone();
        pvLight.m_directionView = (PdVector)this.m_directionView.clone();
        pvLight.m_intensity = (PuDouble)this.m_intensity.clone();
        pvLight.m_intensity.setParent(pvLight);
        pvLight.m_angle = (PuDouble)this.m_angle.clone();
        pvLight.m_angle.setParent(pvLight);
        pvLight.m_corona = (PuDouble)this.m_corona.clone();
        pvLight.m_corona.setParent(pvLight);
        pvLight.m_falloff = (PuDouble)this.m_falloff.clone();
        pvLight.m_falloff.setParent(pvLight);
        pvLight.m_exponent = (PuDouble)this.m_exponent.clone();
        pvLight.m_exponent.setParent(pvLight);
        pvLight.m_blend = (PuDouble)this.m_blend.clone();
        pvLight.m_blend.setParent(pvLight);
        return pvLight;
    }

    public PvDisplayIf getDisplay() {
        return this.m_display;
    }

    public int getReference() {
        return this.m_reference;
    }

    public void setReference(int n) {
        this.m_reference = n;
    }

    public int getShading() {
        return this.m_shading;
    }

    public void setShading(int n) {
        this.m_shading = n;
    }

    public int getLightType() {
        return this.m_lightType;
    }

    public void setLightType(int n) {
        if (n == 5) {
            this.m_reference = 1;
            this.setPosition(0.0, 0.0, 10.0);
            this.setInterest(0.0, 0.0, 0.0);
            this.m_shading = 1;
            this.m_bHighlight = false;
        } else if (n == 6) {
            this.m_reference = 0;
            this.setPosition(0.0, 0.0, 10.0);
            this.setInterest(0.0, 0.0, 0.0);
            this.m_shading = 2;
            this.m_bHighlight = false;
        }
        this.m_lightType = n;
    }

    public boolean isSwitchedOn() {
        return this.m_bSwitchedOn;
    }

    public void setSwitchedOn(boolean bl) {
        this.m_bSwitchedOn = bl;
        if (this.m_color == null) {
            return;
        }
        if (bl) {
            this.updateColor(this.m_color.getColor(), this.m_intensity.getValue());
            this.setGlobalVertexSize(6.0);
            this.setGlobalPolygonSize(4.0);
        } else {
            this.setGlobalPolygonColor(Color.black);
            this.setGlobalVertexSize(3.0);
            this.setGlobalPolygonSize(1.0);
        }
    }

    protected void project() {
        if (this.hasModelMatrix()) {
            this.m_position.leftMultAffin(this.m_modelMatrix, this.m_vertex[0], true);
            this.m_interest.leftMultAffin(this.m_modelMatrix, this.m_vertex[1], true);
        } else {
            this.m_position.copyArray(this.m_vertex[0]);
            this.m_interest.copyArray(this.m_vertex[1]);
        }
        this.m_direction.sub(this.m_interest, this.m_position);
        this.m_direction.setLength(1.0);
    }

    public PdVector getDirection() {
        return this.m_direction;
    }

    public PdVector getPosition() {
        return this.m_position;
    }

    public void setPosition(PdVector pdVector) {
        this.setPosition(pdVector.m_data[0], pdVector.m_data[1], pdVector.m_data[2]);
    }

    public void setPosition(double d, double d2, double d3) {
        if (this.hasModelMatrix()) {
            this.project();
            this.m_modelMatrix.setIdentity();
        }
        this.m_position.set(d, d2, d3);
        this.m_vertex[0].copyArray(this.m_position);
        this.m_direction.sub(this.m_interest, this.m_position);
        this.m_direction.setLength(1.0);
    }

    public PdVector getInterest() {
        return this.m_interest;
    }

    public void setInterest(PdVector pdVector) {
        this.setInterest(pdVector.m_data[0], pdVector.m_data[1], pdVector.m_data[2]);
    }

    public void setInterest(double d, double d2, double d3) {
        if (this.hasModelMatrix()) {
            this.project();
            this.m_modelMatrix.setIdentity();
        }
        this.m_interest.set(d, d2, d3);
        this.m_vertex[1].copyArray(this.m_interest);
        this.setCenter(this.m_vertex[1]);
        this.m_direction.sub(this.m_interest, this.m_position);
        this.m_direction.setLength(1.0);
    }

    protected int[] getColorAsInt() {
        return this.m_matCol;
    }

    public Color getColor() {
        return this.m_color.getColor();
    }

    public void setColor(Color color) {
        this.m_color.setColor(color);
        this.m_matCol[0] = color.getRed();
        this.m_matCol[1] = color.getGreen();
        this.m_matCol[2] = color.getBlue();
        this.updateColor(color, this.m_intensity.getValue());
    }

    public double getIntensity() {
        return this.m_intensity.getValue();
    }

    public void setIntensity(double d) {
        this.m_intensity.setValue(d);
        this.updateColor(this.m_color.getColor(), d);
    }

    private void updateColor(Color color, double d) {
        Color color2 = PdColor.getDimmedColor(color, d);
        this.setGlobalVertexColor(color2);
        if (this.m_bSwitchedOn) {
            this.setGlobalPolygonColor(color2);
        } else {
            this.setGlobalPolygonColor(Color.black);
        }
    }

    public double getAngle() {
        return this.m_angle.getValue();
    }

    public void setAngle(double d) {
        this.m_angle.setValue(d);
    }

    public double getCorona() {
        return this.m_corona.getValue();
    }

    public void setCorona(double d) {
        this.m_corona.setValue(d);
    }

    public double getFalloff() {
        return this.m_falloff.getValue();
    }

    public void setFalloff(double d) {
        this.m_falloff.setValue(d);
    }

    public double getExponent() {
        return this.m_exponent.getValue();
    }

    public void setExponent(double d) {
        this.m_exponent.setValue(d);
    }

    protected double getBlend() {
        return this.m_blend.getValue();
    }

    protected void setBlend(double d) {
        this.m_blend.setValue(d);
    }

    public boolean isHighlight() {
        return this.m_bHighlight;
    }

    public void setHighlight(boolean bl) {
        this.m_bHighlight = bl;
    }
}

