/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer = null;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private Hashtable props = null;
    private Image image = null;
    private boolean wrongColorModel = false;
    private int red = 16;
    private int green = 8;
    private int blue = 0;
    private boolean accumulate = false;
    private int[] accumulator;

    public ImageEncoder(Image image, OutputStream outputStream) {
        this(image.getSource(), outputStream);
        this.image = image;
    }

    public ImageEncoder(ImageProducer imageProducer, OutputStream outputStream) {
        this.producer = imageProducer;
        this.out = outputStream;
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;

    abstract void encodeDone() throws IOException;

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        Graphics graphics = null;
        if (this.image != null) {
            try {
                graphics = this.image.getGraphics();
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalAccessError illegalAccessError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (graphics != null) {
            PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, 1, 1, false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new IOException("image fetch aborted or errored");
            }
            Object object = pixelGrabber.getPixels();
            int n = object instanceof int[] ? ((int[])object)[0] : ((byte[])object)[0];
            Graphics graphics2 = this.image.getGraphics();
            if (graphics2 != null) {
                graphics2.setColor(new Color(4, 2, 1));
                graphics2.drawLine(0, 0, 0, 0);
            }
            pixelGrabber = new PixelGrabber(this.image, 0, 0, 1, 1, false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new IOException("image fetch aborted or errored");
            }
            object = pixelGrabber.getPixels();
            int n2 = 0;
            n2 = object instanceof byte[] ? ((byte[])object)[0] : ((int[])object)[0];
            ColorModel colorModel = pixelGrabber.getColorModel();
            int n3 = colorModel.getRed(n2);
            int n4 = colorModel.getGreen(n2);
            int n5 = colorModel.getBlue(n2);
            if (n3 != 4 || n4 != 2 || n5 != 1) {
                this.red = -1;
                this.green = -1;
                this.blue = -1;
                for (int i = 0; i < 4; ++i) {
                    int n6 = n2 >> i * 8 & 0xFF;
                    if (n6 == 4) {
                        this.red = i * 8;
                        continue;
                    }
                    if (n6 == 2) {
                        this.green = i * 8;
                        continue;
                    }
                    if (n6 != 1) continue;
                    this.blue = i * 8;
                }
                if (this.red != -1 && this.green != -1 && this.blue != -1) {
                    this.wrongColorModel = true;
                }
            }
            if (graphics2 != null) {
                graphics2.setColor(new Color(this.getCorrectRGB(n, colorModel)));
                graphics2.drawLine(0, 0, 0, 0);
            }
        }
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    private int getCorrectRGB(int n, ColorModel colorModel) {
        int n2 = 0;
        n2 += (n >> this.red & 0xFF) << 16;
        n2 += (n >> this.green & 0xFF) << 8;
        n2 += n >> this.blue & 0xFF;
        return n2 += colorModel.getAlpha(n) << 24;
    }

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            for (int i = 0; i < n4; ++i) {
                System.arraycopy(nArray, i * n6 + n5, this.accumulator, (n2 + i) * this.width + n, n3);
            }
        } else {
            this.encodePixels(n, n2, n3, n4, nArray, n5, n6);
        }
    }

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setProperties(Hashtable hashtable) {
        this.props = hashtable;
    }

    public Hashtable getProperties() {
        return this.props;
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n) {
        this.hintflags = n;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3];
        for (int i = 0; i < n4; ++i) {
            int n7 = n5 + i * n6;
            for (int j = 0; j < n3; ++j) {
                nArray[j] = colorModel.getRGB(byArray[n7 + j] & 0xFF);
            }
            try {
                this.encodePixelsWrapper(n, n2 + i, n3, 1, nArray, 0, n3);
                continue;
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == rgbModel && !this.wrongColorModel) {
            try {
                this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        } else {
            int[] nArray2 = new int[n3];
            for (int i = 0; i < n4; ++i) {
                int n7 = n5 + i * n6;
                for (int j = 0; j < n3; ++j) {
                    nArray2[j] = this.wrongColorModel ? this.getCorrectRGB(nArray[n7 + j], colorModel) : colorModel.getRGB(nArray[n7 + j]);
                }
                try {
                    this.encodePixelsWrapper(n, n2 + i, n3, 1, nArray2, 0, n3);
                    continue;
                }
                catch (IOException iOException) {
                    this.iox = iOException;
                    this.stop();
                    return;
                }
            }
        }
    }

    public void imageComplete(int n) {
        this.producer.removeConsumer(this);
        if (n == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException iOException) {
                this.iox = iOException;
            }
        }
        this.stop();
    }
}

