/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import jv.loader.PgFileDialog;
import jv.loader.PsXmlLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsLicense_IP;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;

public final class PsLicense
extends PsObject
implements ActionListener {
    protected static String m_fileName = "jv-lic";
    protected static String m_ext = "lic";
    protected static String m_dir = null;
    protected static String m_version = "1.00.000";
    protected static String m_versionType = "release";
    protected String m_title = "JavaView License File";
    protected static String m_licenseType;
    protected static String m_licenseUsage;
    protected static String m_licenseId;
    protected static String m_licenseExpire;
    protected static PsAuthorInfo m_licenseeInfo;
    protected PsLicense_IP m_lic_IP;
    static /* synthetic */ Class class$jv$rsrc$PsLicense;

    public PsLicense() {
        if (m_dir == null) {
            m_dir = PsConfig.getCodeBase();
        }
        m_licenseType = "evaluation";
        m_licenseUsage = "single";
        m_licenseId = "1000.1000.1000.1000";
        m_licenseExpire = "permanent";
        m_licenseeInfo = new PsAuthorInfo();
        m_licenseeInfo.setProfession("Licensee");
        m_licenseeInfo.setMaxNumAuthors(1);
        if (this.getClass() == (class$jv$rsrc$PsLicense == null ? (class$jv$rsrc$PsLicense = PsLicense.class$("jv.rsrc.PsLicense")) : class$jv$rsrc$PsLicense)) {
            this.init();
        }
    }

    public void init() {
    }

    public boolean update(Object object) {
        if (this.m_lic_IP == object) {
            if (this.m_lic_IP.getUserAction() == 4) {
                if (this.m_lic_IP.m_authorIP != null) {
                    this.m_lic_IP.m_authorIP.accept();
                }
            } else if (this.m_lic_IP.getUserAction() != 1 && this.m_lic_IP.getUserAction() != 128 && this.m_lic_IP.getUserAction() != 32) {
                PsDebug.warning("unknown user action");
            }
            this.m_lic_IP = null;
            return true;
        }
        return super.update(object);
    }

    public static PsAuthorInfo getLicenseeInfo() {
        return m_licenseeInfo;
    }

    public static PsAuthorInfo getAuthorInfo() {
        if (m_licenseeInfo == null) {
            return null;
        }
        PsAuthorInfo psAuthorInfo = (PsAuthorInfo)m_licenseeInfo.clone();
        psAuthorInfo.setProfession(PsConfig.getMessage(24218));
        return psAuthorInfo;
    }

    public final Calendar getLicenseDate() {
        String[] stringArray = PuString.splitString(m_licenseExpire, '-');
        if (stringArray == null || stringArray.length != 3) {
            PsDebug.warning("void expiration date = " + m_licenseExpire);
            return null;
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]) - 1;
        int n3 = Integer.parseInt(stringArray[2]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        return calendar;
    }

    public String getLicenseId() {
        return m_licenseId;
    }

    public String getLicenseType() {
        return m_licenseType;
    }

    public String getLicensee() {
        if (m_licenseeInfo.getNumAuthors() == 0) {
            return "void";
        }
        String string = m_licenseeInfo.getInfo(0, 0) + " " + m_licenseeInfo.getInfo(0, 1);
        return string;
    }

    public void showInfoPanel() {
        this.m_lic_IP = new PsLicense_IP();
        this.m_lic_IP.setParent(this);
        this.m_lic_IP.update(this);
        this.m_lic_IP.setLocation(20, 5);
        ((Component)this.m_lic_IP).setSize(this.m_lic_IP.getDialogSize());
        this.m_lic_IP.addActionListener(this);
        ((Component)this.m_lic_IP).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = actionEvent.getID();
        if (n != 1) {
            if (n == 128) {
                PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24391), 0);
                pgFileDialog.setFile(m_fileName + "." + m_ext);
                if (m_dir != null) {
                    pgFileDialog.setDirectory(m_dir);
                } else {
                    pgFileDialog.setDirectory(PsConfig.getCodeBase());
                }
                ((Component)pgFileDialog).setVisible(true);
                if (pgFileDialog.getDirectory() == null || pgFileDialog.getFile() == null) {
                    return;
                }
                m_dir = pgFileDialog.getDirectory();
                m_dir = PsUtil.assureFileSeparator(m_dir, true);
                m_fileName = pgFileDialog.getFile();
                this.read(m_dir + m_fileName);
                this.m_lic_IP.update(this);
            } else if (n == 32) {
                PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24108), 1);
                pgFileDialog.setFile(m_fileName + "." + m_ext);
                if (m_dir != null) {
                    pgFileDialog.setDirectory(m_dir);
                } else {
                    pgFileDialog.setDirectory(PsConfig.getCodeBase());
                }
                ((Component)pgFileDialog).setVisible(true);
                if (pgFileDialog.getDirectory() == null || pgFileDialog.getFile() == null) {
                    return;
                }
                m_dir = pgFileDialog.getDirectory();
                m_dir = PsUtil.assureFileSeparator(m_dir, true);
                m_fileName = pgFileDialog.getFile();
                this.write(m_dir + m_fileName);
            }
        }
    }

    public boolean read(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("could not read lic file = " + string);
            return false;
        }
        this.setXml(psXmlSrc);
        return true;
    }

    public boolean write(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = this.getXml();
        if (psXmlSrc == null) {
            return true;
        }
        PrintWriter printWriter = PsUtil.writeFile(string);
        if (printWriter == null) {
            PsDebug.warning("could not write to file = " + string);
            return false;
        }
        boolean bl = false;
        try {
            bl = PsXmlSrc.write(printWriter, psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning("could not write lic file = " + string);
        }
        printWriter.close();
        if (!bl) {
            PsDebug.warning("error during export.");
        }
        return bl;
    }

    public PsXmlSrc getXml() {
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        psXmlSrc.setDocName("jv-lic");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-lic.dtd");
        PsXmlNode psXmlNode = new PsXmlNode("jv-lic");
        psXmlSrc.setRootNode(psXmlNode);
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgramAndVersion());
        psXmlNodeArray[1] = psXmlNode.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode2 = psXmlNode.addChild("version", m_version);
        psXmlNode2.addAttribute("type", m_versionType);
        psXmlNode.addChild("title", this.m_title);
        PsXmlNode psXmlNode3 = PsXmlSrc.assureChild(psXmlNode, "license");
        psXmlNode3.addAttribute("type", m_licenseType);
        psXmlNode3.addAttribute("usage", m_licenseUsage);
        psXmlNode3.addChild("license-id", m_licenseId);
        psXmlNode3.addChild("license-expire", m_licenseExpire);
        psXmlNode3.addChild(m_licenseeInfo.getXmlNode().getChild("licensee"));
        return psXmlSrc;
    }

    public void setXml(PsXmlSrc psXmlSrc) {
        if (psXmlSrc == null) {
            PsDebug.warning("missing license.");
            return;
        }
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("missing root node.");
            return;
        }
        if (psXmlNode.getType() == null || !psXmlNode.getType().equalsIgnoreCase("jv-lic")) {
            PsDebug.warning("missing <jv-lic> element,\nthis is not a valid JavaView license file.");
            return;
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, "version");
        if (psXmlNode2 != null) {
            m_version = psXmlNode2.getContent();
            m_versionType = psXmlNode2.getAttribute("type");
        }
        this.m_title = PsXmlSrc.getRsrc(psXmlNode, "title");
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode, "license");
        if (psXmlNode3 != null) {
            m_licenseType = psXmlNode3.getAttribute("type");
            m_licenseUsage = psXmlNode3.getAttribute("usage");
            m_licenseId = PsXmlSrc.getRsrc(psXmlNode3, "license-id");
            m_licenseExpire = PsXmlSrc.getRsrc(psXmlNode3, "license-expire");
            PsXmlNode psXmlNode4 = new PsXmlNode("authors");
            psXmlNode4.addChild(psXmlNode3.getChild("licensee"));
            if (m_licenseeInfo.setXmlNode(psXmlNode4) == 0) {
                PsDebug.warning("missing or void author found in JavaView license.");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

