/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PuData;

public final class PsJavaView
extends PsObject {
    protected static final int m_numFiles = 11;
    public static final int FILE_CODEBASE = 0;
    public static final int FILE_LICENSE = 1;
    public static final int FILE_RESOURCE = 2;
    public static final int FILE_WORKING = 3;
    public static final int FILE_MODELS = 4;
    public static final int FILE_BUG = 5;
    public static final int FILE_VALIDATE = 6;
    public static final int FILE_GEOMETRY = 7;
    public static final int FILE_IMAGE = 8;
    public static final int FILE_LOADERS = 9;
    public static final int FILE_MENU = 10;
    public static final int MONITOR_UXGA = 0;
    public static final int MONITOR_SXGA = 1;
    public static final int MONITOR_XGA = 2;
    public static final int MONITOR_SVGA = 3;
    public static final int MONITOR_VGA = 4;
    public static final int MONITOR_QVGA = 5;
    public static final int MONITOR_USER = 6;
    protected static int[][] m_monitorSize = new int[][]{{1600, 1200}, {1280, 1024}, {1024, 768}, {800, 600}, {640, 480}, {320, 240}, {320, 240}};
    protected static int[][] m_displaySize = new int[][]{{410, 5, 960, 768}, {375, 5, 640, 512}, {375, 5, 640, 512}, {320, 0, 480, 512}, {250, 0, 390, 480}, {160, 0, 160, 240}, {160, 0, 160, 240}};
    protected static int[][] m_controlSize = new int[][]{{5, 5, 400, 900}, {5, 5, 370, 730}, {5, 5, 370, 730}, {0, 0, 320, 600}, {0, 0, 250, 480}, {0, 0, 160, 240}, {0, 0, 160, 240}};
    protected static int[][] m_aboutSize = new int[][]{{10, 10, 400, 450}, {10, 10, 400, 450}, {10, 10, 400, 450}, {0, 0, 400, 450}, {0, 0, 400, 450}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    protected static int[][] m_helpSize = new int[][]{{10, 10, 500, 600}, {10, 10, 500, 550}, {10, 10, 500, 550}, {0, 0, 400, 550}, {0, 0, 400, 480}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    protected static int[][] m_consoleSize = new int[][]{{10, 10, 500, 450}, {10, 10, 500, 450}, {10, 10, 500, 450}, {0, 0, 500, 450}, {0, 0, 500, 350}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    protected static int[][] m_animationSize = new int[][]{{10, 10, 400, 300}, {10, 10, 400, 300}, {10, 10, 400, 300}, {0, 0, 400, 300}, {0, 0, 400, 300}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    protected static int[][] m_newProjectSize = new int[][]{{10, 10, 400, 400}, {10, 10, 400, 400}, {10, 10, 400, 400}, {0, 0, 400, 400}, {0, 0, 400, 400}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    protected static int[][] m_importModelSize = new int[][]{{10, 10, 400, 500}, {10, 10, 400, 500}, {10, 10, 400, 500}, {0, 0, 400, 450}, {0, 0, 400, 450}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    protected static int[][] m_exportBounds = new int[][]{{10, 10, 400, 600}, {10, 10, 400, 600}, {10, 10, 400, 600}, {0, 0, 400, 550}, {0, 0, 400, 480}, {0, 0, 320, 240}, {0, 0, 320, 240}};
    public static final int MONITOR = 0;
    public static final int WINDOW_DISPLAY = 9;
    public static final int WINDOW_CONTROL = 1;
    public static final int WINDOW_ABOUT = 2;
    public static final int WINDOW_HELP = 3;
    public static final int WINDOW_CONSOLE = 4;
    public static final int WINDOW_ANIMATION = 5;
    public static final int WINDOW_NEW_PROJECT = 6;
    public static final int WINDOW_IMPORT_MODEL = 7;
    public static final int WINDOW_EXPORT_MODEL = 8;
    protected static String m_title;
    protected static String m_codeBaseDir;
    protected static String m_modelsDir;
    protected static String m_bugDir;
    protected static String m_validateDir;
    protected static String m_workingDir;
    protected static String m_recentLicDir;
    protected static String m_recentRsrcDir;
    protected static String m_recentGeomDir;
    protected static String m_recentImgDir;
    protected static String m_loadersDir;
    protected static String m_menuDir;
    protected static String m_recentLicFile;
    protected static String m_recentRsrcFile;
    protected static String m_recentGeomFile;
    protected static String m_recentImgFile;
    protected static boolean m_bWorkshopBackup;
    public static boolean m_bAutoIdentify;
    public static boolean m_bAutoNeighbour;
    public static boolean m_bAutoNormals;
    public static boolean m_bAutoElementNormals;
    public static boolean m_bFastClipping;
    public static boolean m_bInstanceSharing;
    public static boolean m_bLargeModel;
    public static boolean m_bOnlyVertices;
    public static boolean m_bFilterVertices;
    public static boolean m_bFilterVertexColors;
    public static boolean m_bFilterVertexNormals;
    public static boolean m_bFilterVertexTexture;
    public static boolean m_bFilterElementColors;
    public static boolean m_bFilterElementNormals;
    public static boolean m_bFilterElementTexture;
    protected static String m_version;
    protected static String m_versionType;
    protected static PsAuthorInfo m_authorInfo;
    public static int m_monitorType;
    public static String m_monitorMouse;
    public static String m_viewerScreen;
    public static String m_viewerVisible;
    public static String m_controlVisible;
    public static boolean m_bControlUsable;
    public static String m_consoleVisible;
    public static boolean m_bConsoleUsable;
    public static boolean m_bCleanDisplay;
    public static boolean m_bAutoLoadDisplay;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    static /* synthetic */ Class class$jv$rsrc$PsJavaView;

    public PsJavaView() {
        this.setName("Preference Settings");
        String string = PsConfig.getCodeBase();
        PsJavaView.setDirectory(0, string);
        PsJavaView.setFileName(2, "jv-rsrc.jvr");
        PsJavaView.setFileName(1, "jv-lic.lic");
        String string2 = PsConfig.getUserBase();
        PsJavaView.setDirectory(3, string2);
        PsJavaView.setDirectory(5, string2 + "bug");
        PsJavaView.setDirectory(6, string2 + "validate");
        PsJavaView.setDirectory(4, string + "models");
        PsJavaView.setFileName(7, "geom.jvx");
        PsJavaView.setFileName(8, "image.jpg");
        PsJavaView.setDirectory(9, "");
        PsJavaView.setDirectory(10, "");
        m_authorInfo = new PsAuthorInfo();
        if (this.getClass() == (class$jv$rsrc$PsJavaView == null ? (class$jv$rsrc$PsJavaView = PsJavaView.class$("jv.rsrc.PsJavaView")) : class$jv$rsrc$PsJavaView)) {
            this.init();
        }
    }

    public static boolean isEnabledWorkshopBackup() {
        return m_bWorkshopBackup;
    }

    public static void setEnabledWorkshopBackup(boolean bl) {
        m_bWorkshopBackup = bl;
    }

    public String getTitle() {
        return m_title;
    }

    public void setTitle(String string) {
        m_title = string;
    }

    public static String getDirectory(int n) {
        switch (n) {
            case 0: {
                return m_codeBaseDir;
            }
            case 2: {
                return m_recentRsrcDir;
            }
            case 1: {
                return m_recentLicDir;
            }
            case 3: {
                return m_workingDir;
            }
            case 5: {
                return m_bugDir;
            }
            case 6: {
                return m_validateDir;
            }
            case 4: {
                return m_modelsDir;
            }
            case 7: {
                return m_recentGeomDir;
            }
            case 8: {
                return m_recentImgDir;
            }
            case 9: {
                return m_loadersDir;
            }
            case 10: {
                return m_menuDir;
            }
        }
        PsDebug.warning("unknown directory identifier: " + String.valueOf(n));
        return null;
    }

    public static void setDirectory(int n, String string) {
        if (PuString.isEmpty(string)) {
            switch (n) {
                case 0: {
                    m_codeBaseDir = null;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                default: {
                    PsDebug.warning("unknown directory identifier: " + String.valueOf(n));
                }
            }
            return;
        }
        switch (n) {
            case 10: {
                m_menuDir = string;
                return;
            }
            case 9: {
                m_loadersDir = string;
                return;
            }
        }
        string = PsUtil.assureFileSeparator(string, true);
        switch (n) {
            case 0: {
                m_codeBaseDir = string;
                m_recentRsrcDir = m_codeBaseDir + "rsrc" + PsConfig.getFileSeparator();
                m_recentLicDir = m_codeBaseDir + "rsrc" + PsConfig.getFileSeparator();
                break;
            }
            case 1: {
                m_recentLicDir = string;
                break;
            }
            case 2: {
                m_recentRsrcDir = string;
                break;
            }
            case 3: {
                m_recentGeomDir = !PuString.isEmpty(m_workingDir) && !PuString.isEmpty(m_recentGeomDir) && m_recentGeomDir.startsWith(m_workingDir) ? string + m_recentGeomDir.substring(m_workingDir.length()) : (!PuString.isEmpty(m_recentGeomDir) && m_recentGeomDir.startsWith(string) ? string + m_recentGeomDir.substring(string.length()) : string + "models" + PsConfig.getFileSeparator());
                m_recentImgDir = !PuString.isEmpty(m_workingDir) && !PuString.isEmpty(m_recentImgDir) && m_recentImgDir.startsWith(m_workingDir) ? string + m_recentImgDir.substring(m_workingDir.length()) : (!PuString.isEmpty(m_recentImgDir) && m_recentImgDir.startsWith(string) ? string + m_recentImgDir.substring(string.length()) : string + "images" + PsConfig.getFileSeparator());
                m_workingDir = string;
                break;
            }
            case 5: {
                m_bugDir = string;
                break;
            }
            case 6: {
                m_validateDir = string;
                break;
            }
            case 4: {
                m_modelsDir = string;
                break;
            }
            case 7: {
                m_recentGeomDir = string;
                break;
            }
            case 8: {
                m_recentImgDir = string;
                break;
            }
            default: {
                PsDebug.warning("unknown directory identifier: " + String.valueOf(n));
            }
        }
    }

    public static String getFileName(int n) {
        switch (n) {
            case 1: {
                return m_recentLicFile;
            }
            case 2: {
                return m_recentRsrcFile;
            }
            case 7: {
                return m_recentGeomFile;
            }
            case 8: {
                return m_recentImgFile;
            }
        }
        return null;
    }

    public static void setFileName(int n, String string) {
        switch (n) {
            case 1: {
                m_recentLicFile = string;
                break;
            }
            case 2: {
                m_recentRsrcFile = string;
                break;
            }
            case 7: {
                m_recentGeomFile = string;
                break;
            }
            case 8: {
                m_recentImgFile = string;
            }
        }
    }

    public static String getFullFileName(int n) {
        String string;
        String string2 = "";
        String string3 = PsJavaView.getDirectory(n);
        if (string3 != null) {
            string2 = string2 + string3;
        }
        if ((string = PsJavaView.getFileName(n)) != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    public static void setFullFileName(int n, String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return;
        }
        if (n == 9 || n == 10) {
            PsJavaView.setDirectory(n, string);
            return;
        }
        String string2 = PsUtil.getFilePath(string);
        if (PuString.isEmpty(string2)) {
            PsDebug.warning("missing directory in fullFileName = " + string);
            return;
        }
        PsJavaView.setDirectory(n, string2);
        String string3 = PsUtil.getFileName(string);
        if (PuString.isEmpty(string3)) {
            return;
        }
        PsJavaView.setFileName(n, string3);
    }

    public static PsAuthorInfo getAuthorInfo() {
        return m_authorInfo;
    }

    public static void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        if (psAuthorInfo == null) {
            m_authorInfo.init();
            return;
        }
        m_authorInfo.copy(psAuthorInfo);
    }

    public static boolean read(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("could not read rsrc file = " + string);
            return false;
        }
        PsJavaView.setXml(psXmlSrc);
        return true;
    }

    public static boolean write(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsJavaView.getXml();
        if (psXmlSrc == null) {
            return true;
        }
        PrintWriter printWriter = PsUtil.writeFile(string);
        if (printWriter == null) {
            PsDebug.warning("could not write to file = " + string);
            return false;
        }
        boolean bl = false;
        try {
            bl = PsXmlSrc.write(printWriter, psXmlSrc);
        }
        catch (IOException iOException) {
            PsDebug.warning("could not write rsrc file = " + string);
        }
        printWriter.close();
        if (!bl) {
            PsDebug.warning("error during export.");
        }
        return bl;
    }

    public static PsXmlSrc getXml() {
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        psXmlSrc.setDocName("jv-rsrc");
        psXmlSrc.setDocType("http://www.javaview.de/rsrc/jv-rsrc.dtd");
        PsXmlNode psXmlNode = new PsXmlNode("jv-rsrc");
        psXmlSrc.setRootNode(psXmlNode);
        PsXmlNode psXmlNode2 = psXmlNode.addChild("meta");
        psXmlNode2.addAttribute("generator", PsConfig.getProgramAndVersion());
        int[] nArray = PsConfig.getVersion(13);
        String string = String.valueOf(nArray[0]) + ".";
        if (nArray[1] < 10) {
            string = string + "0";
        }
        string = string + String.valueOf(nArray[1]);
        if (nArray[2] != 0) {
            string = string + ".";
            if (nArray[2] < 10) {
                string = string + "00";
            } else if (nArray[2] < 100) {
                string = string + "0";
            }
            string = string + String.valueOf(nArray[2]);
        }
        psXmlNode2 = psXmlNode.addChild("meta");
        psXmlNode2.addAttribute("dtd", string);
        psXmlNode2 = psXmlNode.addChild("meta");
        psXmlNode2.addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode3 = psXmlNode.addChild("version", m_version);
        psXmlNode3.addAttribute("type", m_versionType);
        psXmlNode.addChild("title", m_title);
        if (m_authorInfo != null && m_authorInfo.getNumAuthors() > 0) {
            psXmlNode.addChild(m_authorInfo.getXmlNode());
        }
        PsXmlNode psXmlNode4 = psXmlNode.addChild("preferences");
        PsXmlNode psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(3));
        psXmlNode5.addAttribute("type", "working");
        psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(5));
        psXmlNode5.addAttribute("type", "bug");
        psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(6));
        psXmlNode5.addAttribute("type", "validate");
        psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(4));
        psXmlNode5.addAttribute("type", "models");
        psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(9));
        psXmlNode5.addAttribute("type", "loaders");
        psXmlNode5 = psXmlNode4.addChild("directory", PsJavaView.getDirectory(10));
        psXmlNode5.addAttribute("type", "menu");
        PsXmlNode psXmlNode6 = psXmlNode4.addChild("display");
        psXmlNode6.addAttribute("fastDisplay", m_bFastClipping ? "enabled" : "disabled");
        psXmlNode6.addAttribute("instanceSharing", m_bInstanceSharing ? "enabled" : "disabled");
        psXmlNode6.addAttribute("largeModel", m_bLargeModel ? "enabled" : "disabled");
        PsXmlNode psXmlNode7 = psXmlNode4.addChild("loader");
        psXmlNode7.addAttribute("autoIdentify", m_bAutoIdentify ? "enabled" : "disabled");
        psXmlNode7.addAttribute("autoNeighbour", m_bAutoNeighbour ? "enabled" : "disabled");
        psXmlNode7.addAttribute("autoNormals", m_bAutoNormals ? "enabled" : "disabled");
        PsXmlNode psXmlNode8 = psXmlNode4.addChild("workshop");
        psXmlNode8.addAttribute("backup", m_bWorkshopBackup ? "enabled" : "disabled");
        return psXmlSrc;
    }

    protected static int parseEnabled(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("enabled")) {
            return 1;
        }
        return 0;
    }

    public static void setXml(PsXmlSrc psXmlSrc) {
        Object object;
        PsXmlNode psXmlNode;
        Object object2;
        Object object3;
        PsXmlNode psXmlNode2;
        PsXmlNode psXmlNode3;
        String string;
        if (psXmlSrc == null) {
            PsDebug.warning("missing resource.");
            return;
        }
        PsXmlNode psXmlNode4 = psXmlSrc.getRootNode();
        if (psXmlNode4 == null) {
            PsDebug.warning("missing root node.");
            return;
        }
        if (psXmlNode4.getType() == null || !psXmlNode4.getType().equalsIgnoreCase("jv-rsrc")) {
            PsDebug.warning("missing <jv-rsrc> element,\nthis is not a valid JavaView resource file.");
            return;
        }
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNode4, "version");
        if (psXmlNode5 != null) {
            m_version = psXmlNode5.getContent();
            m_versionType = psXmlNode5.getAttribute("type");
        }
        if ((string = PsXmlSrc.getRsrc(psXmlNode4, "title")) != null) {
            m_title = string;
        }
        if ((psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode4, "authors")) != null) {
            m_authorInfo.setXmlNode(psXmlNode3);
        }
        if ((psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode4, "preferences")) != null) {
            object3 = psXmlNode2.getChildren("directory");
            if (object3 != null && ((PsXmlNode[])object3).length > 0) {
                for (int i = 0; i < ((PsXmlNode[])object3).length; ++i) {
                    object2 = object3[i].getAttribute("type");
                    if (object2 == null) continue;
                    if (((String)object2).equalsIgnoreCase("working")) {
                        PsJavaView.setDirectory(3, object3[i].getContent());
                        continue;
                    }
                    if (((String)object2).equalsIgnoreCase("bug")) {
                        PsJavaView.setDirectory(5, object3[i].getContent());
                        continue;
                    }
                    if (((String)object2).equalsIgnoreCase("validate")) {
                        PsJavaView.setDirectory(6, object3[i].getContent());
                        continue;
                    }
                    if (((String)object2).equalsIgnoreCase("models")) {
                        PsJavaView.setDirectory(4, object3[i].getContent());
                        continue;
                    }
                    if (((String)object2).equalsIgnoreCase("loaders")) {
                        PsJavaView.setDirectory(9, object3[i].getContent());
                        continue;
                    }
                    if (!((String)object2).equalsIgnoreCase("menu")) continue;
                    PsJavaView.setDirectory(10, object3[i].getContent());
                }
            }
            if ((psXmlNode = psXmlNode2.getChild("display")) != null) {
                m_bFastClipping = PsJavaView.parseEnabled(psXmlNode.getAttribute("fastDisplay")) == 1;
                m_bInstanceSharing = PsJavaView.parseEnabled(psXmlNode.getAttribute("instanceSharing")) == 1;
                boolean bl = m_bLargeModel = PsJavaView.parseEnabled(psXmlNode.getAttribute("largeModel")) == 1;
            }
            if ((object2 = psXmlNode2.getChild("loader")) != null) {
                m_bAutoIdentify = PsJavaView.parseEnabled(((PsXmlNode)object2).getAttribute("autoIdentify")) != 0;
                m_bAutoNeighbour = PsJavaView.parseEnabled(((PsXmlNode)object2).getAttribute("autoNeighbour")) != 0;
                boolean bl = m_bAutoNormals = PsJavaView.parseEnabled(((PsXmlNode)object2).getAttribute("autoNormals")) != 0;
            }
            if ((object = psXmlNode2.getChild("workshop")) != null) {
                boolean bl = m_bWorkshopBackup = PsJavaView.parseEnabled(((PsXmlNode)object).getAttribute("backup")) != 0;
            }
        }
        if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode4, "windows")) != null) {
            PsXmlNode psXmlNode6;
            PsXmlNode psXmlNode7;
            psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "monitor");
            if (psXmlNode != null) {
                object2 = psXmlNode.getAttribute("size");
                if (object2 != null) {
                    m_monitorType = ((String)object2).startsWith("1600") || ((String)object2).equalsIgnoreCase("UXGA") ? 0 : (((String)object2).startsWith("1280") || ((String)object2).equalsIgnoreCase("SXGA") ? 1 : (((String)object2).startsWith("1024") || ((String)object2).equalsIgnoreCase("XGA") ? 2 : (((String)object2).startsWith("800") || ((String)object2).equalsIgnoreCase("SVGA") ? 3 : (((String)object2).startsWith("640") || ((String)object2).equalsIgnoreCase("VGA") ? 4 : (((String)object2).startsWith("320") || ((String)object2).equalsIgnoreCase("QVGA") ? 5 : 6)))));
                }
                if ((object = psXmlNode.getAttribute("mouse")) != null) {
                    m_monitorMouse = object;
                }
            }
            if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "viewer")) != null) {
                m_viewerScreen = ((PsXmlNode)object2).getAttribute("show");
                m_viewerVisible = ((PsXmlNode)object2).getAttribute("visible");
            }
            if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "control")) != null) {
                m_controlVisible = ((PsXmlNode)object).getAttribute("visible");
            }
            if ((psXmlNode7 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "console")) != null) {
                m_consoleVisible = psXmlNode7.getAttribute("visible");
            }
            if ((psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "fonts")) != null) {
                PsXmlNode psXmlNode8;
                PsXmlNode psXmlNode9;
                PsXmlNode psXmlNode10;
                PsXmlNode psXmlNode11;
                int n;
                PsXmlNode[] psXmlNodeArray = psXmlNode6.getChildren("font");
                if (psXmlNodeArray != null) {
                    for (n = 0; n < psXmlNodeArray.length; ++n) {
                        PsJavaView.parseFont(PsConfig.getOSId(), psXmlNodeArray[n]);
                    }
                }
                if ((psXmlNode11 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_oswin")) != null && PsConfig.getOSId() == 0 && (psXmlNodeArray = psXmlNode11.getChildren("font")) != null) {
                    for (n = 0; n < psXmlNodeArray.length; ++n) {
                        PsJavaView.parseFont(0, psXmlNodeArray[n]);
                    }
                }
                if ((psXmlNode10 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_osirix")) != null && PsConfig.getOSId() == 1 && (psXmlNodeArray = psXmlNode10.getChildren("font")) != null) {
                    for (n = 0; n < psXmlNodeArray.length; ++n) {
                        PsJavaView.parseFont(1, psXmlNodeArray[n]);
                    }
                }
                if ((psXmlNode9 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_ossolaris")) != null && PsConfig.getOSId() == 2 && (psXmlNodeArray = psXmlNode9.getChildren("font")) != null) {
                    for (n = 0; n < psXmlNodeArray.length; ++n) {
                        PsJavaView.parseFont(2, psXmlNodeArray[n]);
                    }
                }
                if ((psXmlNode8 = PsXmlSrc.getRsrcNode(psXmlNode6, "font_oslinux")) != null && PsConfig.getOSId() == 3 && (psXmlNodeArray = psXmlNode8.getChildren("font")) != null) {
                    for (n = 0; n < psXmlNodeArray.length; ++n) {
                        PsJavaView.parseFont(3, psXmlNodeArray[n]);
                    }
                }
            }
        }
    }

    private static boolean parseFont(int n, PsXmlNode psXmlNode) {
        int n2;
        String string = psXmlNode.getContent();
        if (string == null) {
            PsDebug.warning("missing font type");
            return false;
        }
        if (string.equalsIgnoreCase("text")) {
            n2 = 0;
        } else if (string.equalsIgnoreCase("fixed")) {
            n2 = 1;
        } else if (string.equalsIgnoreCase("menu")) {
            n2 = 2;
        } else if (string.equalsIgnoreCase("header2")) {
            n2 = 3;
        } else if (string.equalsIgnoreCase("header4")) {
            n2 = 4;
        } else {
            PsDebug.warning("invalid font type");
            return false;
        }
        String string2 = psXmlNode.getAttribute("name");
        if (PuString.isEmpty(string2)) {
            string2 = null;
        }
        int n3 = -1;
        String string3 = psXmlNode.getAttribute("style");
        if (string3 != null) {
            if (string3.equalsIgnoreCase("bold")) {
                n3 = 1;
            } else if (string3.equalsIgnoreCase("plain")) {
                n3 = 0;
            } else if (string3.equalsIgnoreCase("italic")) {
                n3 = 2;
            } else if (string3.equalsIgnoreCase("")) {
                n3 = -1;
            } else {
                PsDebug.warning("invalid font style = " + string3);
                return false;
            }
        }
        int n4 = -1;
        String string4 = psXmlNode.getAttribute("size");
        if (string4 != null) {
            if (string4.length() == 0) {
                n4 = -1;
            } else {
                try {
                    n4 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("invalid font size = " + string4);
                    return false;
                }
            }
        }
        PsConfig.setFont(n, n2, string2, n3, n4);
        return true;
    }

    public static int getMonitorType() {
        return m_monitorType;
    }

    public static void setMonitorType(int n) {
        m_monitorType = n;
    }

    public static int[] getWindowSize(int n) {
        int[] nArray;
        switch (n) {
            case 0: {
                nArray = m_monitorSize[m_monitorType];
                break;
            }
            case 9: {
                nArray = m_displaySize[m_monitorType];
                break;
            }
            case 1: {
                nArray = m_controlSize[m_monitorType];
                break;
            }
            case 2: {
                nArray = m_aboutSize[m_monitorType];
                break;
            }
            case 3: {
                nArray = m_helpSize[m_monitorType];
                break;
            }
            case 4: {
                nArray = m_consoleSize[m_monitorType];
                break;
            }
            case 5: {
                nArray = m_animationSize[m_monitorType];
                break;
            }
            case 6: {
                nArray = m_newProjectSize[m_monitorType];
                break;
            }
            case 7: {
                nArray = m_importModelSize[m_monitorType];
                break;
            }
            case 8: {
                nArray = m_exportBounds[m_monitorType];
                break;
            }
            default: {
                PsDebug.warning("unknown window identifier = " + n);
                Object var1_2 = null;
                return null;
            }
        }
        int[] nArray2 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
        return nArray2;
    }

    public static boolean setWindowSize(int n, int[] nArray) {
        switch (n) {
            case 0: {
                PuData.copy(m_monitorSize[m_monitorType], nArray);
                break;
            }
            case 9: {
                PuData.copy(m_displaySize[m_monitorType], nArray);
                break;
            }
            case 1: {
                PuData.copy(m_controlSize[m_monitorType], nArray);
                break;
            }
            case 2: {
                PuData.copy(m_aboutSize[m_monitorType], nArray);
                break;
            }
            case 3: {
                PuData.copy(m_helpSize[m_monitorType], nArray);
                break;
            }
            case 4: {
                PuData.copy(m_consoleSize[m_monitorType], nArray);
                break;
            }
            case 5: {
                PuData.copy(m_animationSize[m_monitorType], nArray);
                break;
            }
            case 6: {
                PuData.copy(m_newProjectSize[m_monitorType], nArray);
                break;
            }
            case 7: {
                PuData.copy(m_importModelSize[m_monitorType], nArray);
                break;
            }
            case 8: {
                PuData.copy(m_exportBounds[m_monitorType], nArray);
                break;
            }
            default: {
                PsDebug.warning("unknown window identifier = " + n);
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_bWorkshopBackup = true;
        m_bAutoIdentify = true;
        m_bAutoNeighbour = true;
        m_bAutoNormals = true;
        m_bAutoElementNormals = false;
        m_bFastClipping = true;
        m_bInstanceSharing = false;
        m_bLargeModel = false;
        m_bOnlyVertices = false;
        m_bFilterVertices = false;
        m_bFilterVertexColors = false;
        m_bFilterVertexNormals = false;
        m_bFilterVertexTexture = false;
        m_bFilterElementColors = false;
        m_bFilterElementNormals = false;
        m_bFilterElementTexture = false;
        m_version = "0.99.081";
        m_versionType = "beta";
        m_monitorType = 2;
        m_viewerScreen = "multiple";
        m_viewerVisible = "show";
        m_controlVisible = "hide";
        m_bControlUsable = true;
        m_consoleVisible = "hide";
        m_bConsoleUsable = true;
        m_bCleanDisplay = false;
        m_bAutoLoadDisplay = false;
    }
}

