/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.object.PsUtil;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsJavaView;
import jv.viewer.PvViewer;

public abstract class PvApplet
extends Applet
implements Runnable {
    protected Frame m_frame;
    protected PvViewer m_viewer;
    private String m_drawString;
    protected String m_preferredPanelPosition = "East";

    public abstract String getAppletInfo();

    public abstract PjProject getProject();

    public Rectangle getSizeOfFrame() {
        int[] nArray = PsJavaView.getWindowSize(9);
        return new Rectangle(nArray[0], nArray[1], 812, 512);
    }

    public void init() {
        this.drawMessage("Loading viewer ...");
        if (this.m_viewer == null) {
            this.m_viewer = new PvViewer(this, this.m_frame);
        }
        PsConfig.setProgramExtension(PsUtil.getSimpleClassName(this));
        Thread thread = new Thread((Runnable)this, PsConfig.getProgram() + ": initializing applet ...");
        thread.setPriority(5);
        thread.start();
    }

    public void run() {
        this.drawMessage("Loading project ...");
        PjProject pjProject = this.getProject();
        if (pjProject != null) {
            this.m_viewer.addProject(pjProject);
            this.m_viewer.selectProject(pjProject);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_viewer.getDisplay().getCanvas(), "Center");
        if (pjProject != null && !"Hide".equalsIgnoreCase(this.m_viewer.getParameter("ProjectPanel"))) {
            this.add((Component)this.m_viewer.getPanel(10), this.m_preferredPanelPosition);
        }
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public static void main(PvApplet pvApplet, String[] stringArray) {
        PsMainFrame psMainFrame = new PsMainFrame(pvApplet, stringArray);
        pvApplet.m_frame = psMainFrame;
        pvApplet.m_viewer = new PvViewer(pvApplet, psMainFrame);
        Rectangle rectangle = pvApplet.getSizeOfFrame();
        Point point = new Point(rectangle.x, rectangle.y);
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        psMainFrame.pack();
        pvApplet.init();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = PsMainFrame.getTotalHeightOther(psMainFrame, pvApplet);
        dimension = new Dimension(dimension.width, dimension.height + n / PsConfig.getMonitorScale());
        psMainFrame.setInnerBounds(new Rectangle(point, dimension));
        ((Component)psMainFrame).setVisible(true);
    }

    public PvViewerIf getViewer() {
        return this.m_viewer;
    }

    public PvDisplayIf getDisplay() {
        if (this.m_viewer == null) {
            return null;
        }
        return this.m_viewer.getDisplay();
    }

    public void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgramAndVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }
}

