/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import jv.loader.PgAbstractLoader;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgByuLoader
extends PgAbstractLoader {
    public static PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgByuLoader pgByuLoader = new PgByuLoader();
        PgJvxSrc[] pgJvxSrcArray = pgByuLoader.read(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pgByuLoader = null;
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            pgJvxSrcArray[0].setName(PsUtil.getFileBaseName(string));
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setType(33);
        try {
            boolean bl = PgByuLoader.parse(bufferedReader, pgJvxSrc);
            if (!bl) {
                PsDebug.warning("error during parsing of reader");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("error when during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        PgByuLoader.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                break;
            }
            case 33: {
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                break;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
            }
        }
    }

    protected static boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.ordinaryChars(48, 48);
        streamTokenizer.ordinaryChars(49, 57);
        streamTokenizer.ordinaryChars(46, 46);
        streamTokenizer.ordinaryChars(32, 32);
        streamTokenizer.ordinaryChars(45, 45);
        streamTokenizer.ordinaryChars(43, 43);
        streamTokenizer.wordChars(48, 48);
        streamTokenizer.wordChars(49, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(32, 32);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.nextToken();
        String string = streamTokenizer.sval;
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        int n9 = string.length();
        boolean bl = true;
        char c = string.charAt(n9 - 1);
        if (c == '0' && string.charAt(n9 - 2) == ' ') {
            n7 = n9 / 5;
        } else if (c == '8' && string.charAt(n9 - 2) == ' ') {
            PsDebug.notify("Grape format found");
            n7 = n9 / 6;
        } else if (c == '5' && string.charAt(n9 - 2) == ' ') {
            PsDebug.notify("Microsoft format found");
            n7 = n9 / 5;
        } else {
            PsDebug.warning("cannot determine number format from header\n\tdump of currently scanned string: " + string + "\n\tno meaningful format used in header, continue");
            boolean bl2 = bl = n9 / 4 * 4 == n9;
            if (bl) {
                n7 = n9 / 4;
            }
        }
        try {
            n3 = Integer.parseInt(string.substring(0 * n7, 1 * n7).trim());
            n4 = Integer.parseInt(string.substring(1 * n7, 2 * n7).trim());
            n5 = Integer.parseInt(string.substring(2 * n7, 3 * n7).trim());
            n6 = Integer.parseInt(string.substring(3 * n7, 4 * n7).trim());
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("error in header\n\tdump of currently scanned string: " + string + "\n\tnumber format error in header");
            return false;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            PsDebug.warning("error in part list\n\tdump of currently scanned string: " + string + "\n\tstring index out of bounds error in header");
            return false;
        }
        int[] nArray = new int[2 * n3];
        int n10 = 0;
        int n11 = 0;
        try {
            while (n10 < 2 * n3) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                string = streamTokenizer.sval;
                n9 = string.length();
                n11 = 0;
                while (n11 < n9 && n10 < 2 * n3) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        nArray[n10 + n2] = Integer.parseInt(string.substring(n11, n11 + n7).trim());
                        n11 += n7;
                    }
                    n10 += 2;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("error in part list\n\tdump of currently scanned string: " + string + "\n\tdump of current segment: " + string.substring(n11, n11 + n7) + "\n\tnumber format error in part list");
            return false;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            PsDebug.warning("error in part list = " + n10 + "\n\tdump of currently scanned string: " + string + "\n\tstring index out of bounds error in part list");
            return false;
        }
        PsDebug.notify("parsing vertices ...");
        n2 = 3;
        pgJvxSrc.setDimOfVertices(n2);
        pgJvxSrc.setNumVertices(n4);
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        int n12 = 0;
        n8 = 12;
        try {
            if (bl) {
                for (n10 = 0; n10 < n4; ++n10) {
                    if (n10 % 2 == 0) {
                        n12 = 0;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        string = streamTokenizer.sval;
                    }
                    for (int i = 0; i < n2; ++i) {
                        pdVectorArray[n10].m_data[i] = Double.valueOf(string.substring(n12, n12 + n8).trim());
                        n12 += n8;
                    }
                }
            } else {
                n10 = 0;
                StreamTokenizer streamTokenizer2 = null;
                for (n10 = 0; n10 < n4; ++n10) {
                    if (n10 % 2 == 0) {
                        n12 = 0;
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        string = streamTokenizer.sval;
                        streamTokenizer2 = new StreamTokenizer(new StringReader(string));
                        streamTokenizer2.eolIsSignificant(true);
                        streamTokenizer2.wordChars(65, 90);
                        streamTokenizer2.wordChars(97, 122);
                        streamTokenizer2.ordinaryChars(48, 48);
                        streamTokenizer2.ordinaryChars(49, 57);
                        streamTokenizer2.ordinaryChars(46, 46);
                        streamTokenizer2.ordinaryChars(45, 45);
                        streamTokenizer2.ordinaryChars(43, 43);
                        streamTokenizer2.wordChars(48, 48);
                        streamTokenizer2.wordChars(49, 57);
                        streamTokenizer2.wordChars(46, 46);
                        streamTokenizer2.wordChars(45, 45);
                        streamTokenizer2.wordChars(43, 43);
                        streamTokenizer2.ordinaryChars(47, 47);
                        streamTokenizer2.commentChar(35);
                    }
                    for (n = 0; n < n2; ++n) {
                        streamTokenizer2.nextToken();
                        pdVectorArray[n10].m_data[n] = Double.valueOf(streamTokenizer2.sval.trim());
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("error at vertex = " + n10 + "\n\tdump of currently scanned string: " + string.substring(n12, n12 + n8) + "\n\tnumber format error in vertex list");
            return false;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            PsDebug.warning("error at vertex = " + n10 + "\n\tvertex-line = " + n10 / 2 + "\n\tdump of currently scanned string: " + string + "\n\tstring index out of bounds error in vertex list");
            return false;
        }
        PsDebug.notify("parsing connectivity ...");
        pgJvxSrc.setDimOfElements(-1);
        pgJvxSrc.setNumElements(n5);
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        n = 0;
        int n13 = 0;
        int n14 = 100;
        int[] nArray2 = new int[n14];
        try {
            n12 = 0;
            streamTokenizer.nextToken();
            streamTokenizer.nextToken();
            string = streamTokenizer.sval;
            n9 = streamTokenizer.sval.length();
            for (n10 = 0; n10 < n6; ++n10) {
                if (n12 == n9) {
                    n12 = 0;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    string = streamTokenizer.sval;
                    n9 = streamTokenizer.sval.length();
                }
                int n15 = Integer.parseInt(string.substring(n12, n12 + n7).trim());
                n12 += n7;
                if (n15 > 0) {
                    nArray2[n13++] = n15 - 1;
                    continue;
                }
                nArray2[n13++] = -n15 - 1;
                piVectorArray[n].setSize(n13);
                piVectorArray[n].copy(nArray2, n13);
                ++n;
                n13 = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("error at connectivity entry = " + n10 + "\n\tdump of currently scanned string: " + string.substring(n12, n12 + n7) + "\n\tnumber format error in conncetivity list");
            return false;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            PsDebug.warning("error at connectivity entry = " + n10 + "\n\tconn-line = " + n10 / 16 + "\n\tdump of currently scanned string: " + string + "\n\tstring index out of bounds error in conncetivity list");
            return false;
        }
        PsDebug.notify("... finished");
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        int n2;
        int n3;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        int n4 = pgJvxSrc.getNumVertices();
        int n5 = pgJvxSrc.getNumElements();
        PiVector[] piVectorArray = pgJvxSrc.getElements();
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n6 += piVectorArray[n3].getSize();
        }
        writer.write(PuString.intToString(1, 6) + PuString.intToString(n4, 6) + PuString.intToString(n5, 6) + PuString.intToString(n6, 6) + PuString.intToString(0, 6) + "\n" + PuString.intToString(1, 6) + PuString.intToString(n5, 6) + "\n");
        n3 = 0;
        PdVector[] pdVectorArray = pgJvxSrc.getVertices();
        int n7 = Math.min(3, pgJvxSrc.getDimOfVertices());
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n7; ++n) {
                writer.write(PuString.doubleToString(pdVectorArray[n2].m_data[n], 5));
                if (n3 == 5) {
                    n3 = 0;
                    writer.write("\n");
                    continue;
                }
                ++n3;
            }
            for (n = n7; n < 3; ++n) {
                writer.write(PuString.doubleToString(0.0, 5));
                if (n3 == 5) {
                    n3 = 0;
                    writer.write("\n");
                    continue;
                }
                ++n3;
            }
        }
        if (n3 != 0) {
            writer.write("\n");
        }
        n3 = 0;
        for (n = 0; n < n5; ++n) {
            int n8 = piVectorArray[n].getSize();
            for (int i = 0; i < n8; ++i) {
                n2 = piVectorArray[n].m_data[i] + 1;
                if (i == n8 - 1) {
                    writer.write(PuString.intToString(-n2, 6));
                } else {
                    writer.write(PuString.intToString(n2, 6));
                }
                if (n3 == 15) {
                    n3 = 0;
                    writer.write("\n");
                    continue;
                }
                ++n3;
            }
        }
        if (n3 != 0) {
            writer.write("\n");
        }
        return true;
    }
}

