/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.util.Vector;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;

public class PuCleanMesh {
    public static int identifyVertices(PgGeometry pgGeometry) {
        if (!(pgGeometry instanceof PgPointSet)) {
            PsDebug.warning("Geometry not instance of PgPointSet, name = " + pgGeometry.getClass());
            return 0;
        }
        PgPointSet pgPointSet = (PgPointSet)pgGeometry;
        int n = PuCleanMesh.identifyVertices(pgPointSet, 0.0, false);
        if (n > 0 && pgPointSet.hasVertexNormals()) {
            switch (pgGeometry.getType()) {
                case 33: {
                    ((PgElementSet)pgGeometry).makeVertexNormals();
                    break;
                }
                case 31: {
                    ((PgPolygon)pgGeometry).makeVertexNormals();
                    break;
                }
                case 32: {
                    ((PgPolygonSet)pgGeometry).makeVertexNormals();
                }
            }
        }
        return n;
    }

    public static int identifyVertices(PgPointSet pgPointSet, double d) {
        return PuCleanMesh.identifyVertices(pgPointSet, d, false);
    }

    public static int identifyVertices(PgPointSet pgPointSet, double d, boolean bl) {
        int n;
        PgElementSet pgElementSet;
        int n2;
        if (pgPointSet == null) {
            return 0;
        }
        int n3 = pgPointSet.getNumVertices();
        if (n3 < 2) {
            return 0;
        }
        int n4 = pgPointSet.getDimOfVertices();
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        boolean bl2 = pgPointSet.hasVertexNormals();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        PdVector[] pdVectorArray2 = pgPointSet.getBounds();
        PdVector pdVector = PdVector.subNew(pdVectorArray2[1], pdVectorArray2[0]);
        if (pdVector.getSize() != n4) {
            pdVector.setSize(n4);
        }
        pdVector.setLength(1.0);
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = n2;
            dArray[n2] = PdVector.dot(pdVector, pdVectorArray[n2]);
        }
        PuMath.heapsort(n3, dArray, nArray2);
        boolean bl3 = false;
        if (pgPointSet.getType() == 33 && (bl3 = (pgElementSet = (PgElementSet)pgPointSet).hasBoundary())) {
            pgElementSet.markBoundary();
        }
        boolean bl4 = false;
        boolean bl5 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[nArray2[n2]] != nArray2[n2] || bl && !pdVectorArray[nArray2[n2]].hasTag(1)) continue;
            for (int i = n2 + 1; i < n3 && !(dArray[nArray2[i]] > dArray[nArray2[n2]] + d); ++i) {
                if (bl && !pdVectorArray[nArray2[i]].hasTag(1) || bl4 && pdVectorArray[nArray2[i]].hasTag(14)) continue;
                int n5 = 0;
                for (int j = 0; j < n4 && !(Math.abs(pdVectorArray[nArray2[n2]].m_data[j] - pdVectorArray[nArray2[i]].m_data[j]) > d); ++j) {
                    ++n5;
                }
                if (n5 != n4) continue;
                nArray[nArray2[i]] = nArray2[n2];
                if (bl5) continue;
                bl5 = true;
            }
        }
        if (!bl5) {
            return 0;
        }
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            int n6 = nArray[n];
            nArray3[n6] = nArray3[n6] + 1;
            if (nArray[n] == n) continue;
            pdVectorArray[nArray[n]].add(pdVectorArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            if (nArray3[nArray[n]] <= 1) continue;
            pdVectorArray[n].multScalar(1.0 / (double)nArray3[nArray[n]]);
        }
        switch (pgPointSet.getType()) {
            case 30: {
                PuCleanMesh.identifyVerticesPointSet(pgPointSet, nArray);
                break;
            }
            case 33: {
                PuCleanMesh.identifyVerticesElementSet((PgElementSet)pgPointSet, nArray);
                break;
            }
            case 31: {
                PuCleanMesh.identifyVerticesPolygon((PgPolygon)pgPointSet, nArray);
                break;
            }
            case 32: {
                PuCleanMesh.identifyVerticesPolygonSet((PgPolygonSet)pgPointSet, nArray);
                break;
            }
            default: {
                PuCleanMesh.identifyVerticesPointSet(pgPointSet, nArray);
            }
        }
        if (bl2) {
            pgPointSet.makeVertexNormals();
        }
        return n3 - pgPointSet.getNumVertices();
    }

    private static void identifyVerticesElementSet(PgElementSet pgElementSet, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = pgElementSet.getNumVertices();
        int n7 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        for (int i = 0; i < n7; ++i) {
            n5 = piVectorArray[i].getSize();
            for (int j = 0; j < n5; ++j) {
                piVectorArray[i].m_data[j] = nArray[piVectorArray[i].m_data[j]];
            }
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            for (n5 = 0; n5 < pgBndPolygonArray.length; ++n5) {
                if (pgBndPolygonArray[n5].hasTag(2)) continue;
                PiVector piVector = pgBndPolygonArray[n5].getVertexInd();
                int n8 = pgBndPolygonArray[n5].getNumVertices();
                boolean bl = true;
                for (n4 = 0; n4 < n8; ++n4) {
                    if (piVector.m_data[n4] != -1 && piVector.m_data[n4] < n6) continue;
                    pgBndPolygonArray[n5].setTag(2);
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (n4 = 0; n4 < n8; ++n4) {
                    piVector.m_data[n4] = nArray[piVector.m_data[n4]];
                }
                piVector.removeSuccessiveDuplicates();
                if (piVector.getSize() > 1) {
                    pgBndPolygonArray[n5].assignVertices();
                    continue;
                }
                pgBndPolygonArray[n5].setTag(2);
            }
            pgElementSet.removeDeletedBoundaries();
        }
        PuCleanMesh.removeDegenerateElements(pgElementSet);
        pgElementSet.removeUnusedVertices();
        n7 = pgElementSet.getNumElements();
        n6 = pgElementSet.getNumVertices();
        piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        Vector[] vectorArray = new Vector[n6];
        for (n3 = 0; n3 < n7; ++n3) {
            PiVector piVector = piVectorArray[n3];
            PiVector piVector2 = piVectorArray2[n3];
            n4 = piVector.getSize();
            if (piVector2 == null || piVector2.getSize() != n4) {
                PsDebug.warning("Missing neighbour information");
                continue;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n9;
                if (piVector2.m_data[n2] != -1) continue;
                if (piVector.m_data[(n2 + 1) % n4] < piVector.m_data[(n2 + 2) % n4]) {
                    n = piVector.m_data[(n2 + 1) % n4];
                    n9 = piVector.m_data[(n2 + 2) % n4];
                } else {
                    n9 = piVector.m_data[(n2 + 1) % n4];
                    n = piVector.m_data[(n2 + 2) % n4];
                }
                if (vectorArray[n] == null || vectorArray[n].size() == 0) {
                    vectorArray[n] = new Vector();
                }
                vectorArray[n].addElement(new PiVector(n9, n3, n2));
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            int n10;
            if (vectorArray[n3] == null || (n10 = vectorArray[n3].size()) <= 1) continue;
            boolean[] blArray = new boolean[n10];
            for (n4 = 0; n4 < n10; ++n4) {
                blArray[n4] = false;
            }
            for (n4 = 0; n4 < n10; ++n4) {
                if (blArray[n4]) continue;
                n2 = -1;
                blArray[n4] = true;
                n = ((PiVector)vectorArray[n3].elementAt((int)n4)).m_data[0];
                for (int i = n4 + 1; i < n10; ++i) {
                    if (n != ((PiVector)vectorArray[n3].elementAt((int)i)).m_data[0]) continue;
                    blArray[i] = true;
                    n2 = n2 == -1 ? i : -2;
                }
                if (n2 <= -1) continue;
                PiVector piVector = (PiVector)vectorArray[n3].elementAt(n4);
                PiVector piVector3 = (PiVector)vectorArray[n3].elementAt(n2);
                piVectorArray2[piVector.m_data[1]].m_data[piVector.m_data[2]] = piVector3.m_data[1];
                piVectorArray2[piVector3.m_data[1]].m_data[piVector3.m_data[2]] = piVector.m_data[1];
            }
        }
    }

    private static void identifyVerticesPointSet(PgPointSet pgPointSet, int[] nArray) {
        int n = pgPointSet.getNumVertices();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != i) {
                pgPointSet.setTagVertex(i, 2);
                continue;
            }
            pgPointSet.clearTagVertex(nArray[i], 2);
        }
        pgPointSet.removeMarkedVertices();
    }

    private static void identifyVerticesPolygonSet(PgPolygonSet pgPolygonSet, int[] nArray) {
        int n = pgPolygonSet.getNumVertices();
        if (n == 0) {
            return;
        }
        int n2 = pgPolygonSet.getNumPolygons();
        for (int i = 0; i < n2; ++i) {
            PiVector piVector = pgPolygonSet.getPolygon(i);
            int n3 = piVector.getSize();
            if (n3 == 0) continue;
            piVector.m_data[0] = nArray[piVector.m_data[0]];
            int n4 = 1;
            for (int j = 1; j < n3; ++j) {
                if (nArray[piVector.m_data[j]] == nArray[piVector.m_data[j - 1]]) continue;
                piVector.m_data[n4] = nArray[piVector.m_data[j]];
                ++n4;
            }
            piVector.setSize(n4);
            if (n4 != 1) continue;
            piVector.setTag(2);
        }
        pgPolygonSet.removeMarkedPolygons();
        pgPolygonSet.removeUnusedVertices();
    }

    private static void identifyVerticesPolygon(PgPolygon pgPolygon, int[] nArray) {
        int n;
        int n2 = pgPolygon.getNumVertices();
        if (n2 == 0) {
            return;
        }
        for (n = 1; n < n2; ++n) {
            pgPolygon.setTagVertex(n, 2);
        }
        if (nArray[0] != 0) {
            pgPolygon.setVertex(0, pgPolygon.getVertex(nArray[0]));
        }
        for (n = 1; n < n2; ++n) {
            if (nArray[n] == nArray[n - 1]) continue;
            if (nArray[n] != n) {
                pgPolygon.setVertex(n, pgPolygon.getVertex(nArray[n]));
            }
            pgPolygon.clearTagVertex(n, 2);
        }
        pgPolygon.removeMarkedVertices();
    }

    public static int getNumDegenerateElements(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            return 0;
        }
        int n = pgElementSet.getNumElements();
        int n2 = 0;
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector = pgElementSet.getElement(i);
            int n3 = piVector.getSize();
            if (n3 < 3) {
                ++n2;
                continue;
            }
            for (int j = 0; j < n3 - 1; ++j) {
                for (int k = j + 1; k < n3; ++k) {
                    if (piVector.m_data[j] != piVector.m_data[k]) continue;
                    ++n2;
                    continue block0;
                }
            }
        }
        return n2;
    }

    public static void removeDegenerateElements(PgElementSet pgElementSet) {
        int n;
        int n2;
        PiVector piVector;
        int n3;
        if (pgElementSet == null) {
            return;
        }
        int n4 = pgElementSet.getNumElements();
        boolean bl = false;
        PiVector piVector2 = null;
        PiVector piVector3 = null;
        PiVector piVector4 = null;
        boolean bl2 = pgElementSet.getNeighbours() != null;
        boolean bl3 = pgElementSet.hasElementColors();
        boolean bl4 = pgElementSet.hasElementBackColors();
        boolean bl5 = pgElementSet.hasElementNormals();
        boolean bl6 = pgElementSet.hasElementTextures();
        int n5 = pgElementSet.getNumVectorFields();
        for (n3 = 0; n3 < n4; ++n3) {
            int n6;
            int n7;
            int n8;
            int n9;
            piVector = pgElementSet.getElement(n3);
            if (bl2) {
                piVector2 = pgElementSet.getNeighbour(n3);
            }
            for (n9 = n8 = piVector.getSize(); n9 > 1 && piVector.m_data[n9 - 1] == piVector.m_data[0]; --n9) {
            }
            if (n9 != n8) {
                bl = true;
                piVector.setSize(n9);
                if (bl2) {
                    piVector2.m_data[n9 - 1] = piVector2.m_data[n8 - 1];
                    piVector2.setSize(n9);
                }
            }
            if (n9 < 3) {
                piVector.setTag(2);
                bl = true;
                continue;
            }
            n2 = 0;
            block2: for (n = 0; n < n9 - 1; ++n) {
                for (n7 = n + 1; n7 < n9; ++n7) {
                    if (piVector.m_data[n] != piVector.m_data[n7]) continue;
                    n2 = 1;
                    break block2;
                }
            }
            if (n2 == 0) continue;
            n = piVector.m_data[0];
            n7 = 1;
            int n10 = -1;
            for (n6 = 1; n6 < n9; ++n6) {
                if (piVector.m_data[n6] != n) {
                    piVector.m_data[n7] = piVector.m_data[n6];
                    if (bl2) {
                        if (n7 == 1) {
                            n10 = n6 == 1 ? piVector2.m_data[n9 - 1] : piVector2.m_data[n6 - 2];
                        } else {
                            piVector2.m_data[n7 - 2] = piVector2.m_data[n6 - 2];
                        }
                    }
                    ++n7;
                } else {
                    bl = true;
                }
                n = piVector.m_data[n6];
            }
            if (bl2) {
                piVector2.m_data[n7 - 2] = piVector2.m_data[n9 - 2];
                piVector2.m_data[n7 - 1] = n10;
                piVector2.setSize(n7);
            }
            piVector.setSize(n7);
            n6 = 0;
            while (n6 != -1) {
                int n11;
                Object object;
                PdVector[] pdVectorArray;
                int n12;
                int n13;
                int n14;
                n6 = -1;
                int n15 = -1;
                for (n14 = 0; n14 < n7 - 1; ++n14) {
                    for (n13 = n14 + 1; n13 < n7; ++n13) {
                        if (piVector.m_data[n14] != piVector.m_data[n13]) continue;
                        n6 = n14;
                        n15 = n13;
                        break;
                    }
                    if (n6 != -1) break;
                }
                if (n6 == -1) break;
                bl = true;
                n14 = n15 - n6;
                n13 = n7 + n6 - n15;
                PiVector piVector5 = new PiVector(n14);
                PiVector piVector6 = new PiVector(n13);
                for (n12 = 0; n12 < n14; ++n12) {
                    piVector5.m_data[n12] = piVector.m_data[(n12 + n6) % n7];
                }
                for (n12 = 0; n12 < n13; ++n12) {
                    piVector6.m_data[n12] = piVector.m_data[(n12 + n15) % n7];
                }
                if (bl2) {
                    piVector3 = new PiVector(n14);
                    piVector4 = new PiVector(n13);
                    for (n12 = 0; n12 < n14; ++n12) {
                        piVector3.m_data[(n12 + n14 - 1) % n14] = piVector2.m_data[(n12 + n6 + n7 - 1) % n7];
                    }
                    for (n12 = 0; n12 < n13; ++n12) {
                        piVector4.m_data[(n12 + n13 - 1) % n13] = piVector2.m_data[(n12 + n15 + n7 - 1) % n7];
                    }
                }
                pgElementSet.setNumElements(n4 + 1);
                PiVector piVector7 = pgElementSet.getElement(n4);
                if (bl3) {
                    pgElementSet.setElementColor(n4, pgElementSet.getElementColor(n3));
                }
                if (bl4) {
                    pgElementSet.setElementBackColor(n4, pgElementSet.getElementBackColor(n3));
                }
                for (int i = 0; i < n5; ++i) {
                    pdVectorArray = pgElementSet.getVectorField(i);
                    if (pdVectorArray.getBasedOn() != 1) continue;
                    pdVectorArray.setNumVectors(n4 + 1);
                    pdVectorArray.setVector(n4, PdVector.copyNew(pdVectorArray.getVector(n3)));
                }
                piVector7.setSize(n13);
                piVector7.copy(piVector6);
                if (n13 < 3) {
                    pgElementSet.setTagElement(n4, 2);
                }
                if (bl6) {
                    PdVector[] pdVectorArray2 = pgElementSet.getElementTexture(n3);
                    pdVectorArray = new PdVector[n14];
                    object = new PdVector[n13];
                    for (n11 = 0; n11 < n14; ++n11) {
                        pdVectorArray[n11] = PdVector.copyNew(pdVectorArray2[(n11 + n6) % n7]);
                    }
                    for (n11 = 0; n11 < n13; ++n11) {
                        object[n11] = PdVector.copyNew(pdVectorArray2[(n11 + n15) % n7]);
                    }
                    pgElementSet.setElementTexture(n3, pdVectorArray);
                    pgElementSet.setElementTexture(n4, (PdVector[])object);
                }
                if (bl2) {
                    PiVector piVector8 = pgElementSet.getNeighbour(n4);
                    piVector8.setSize(n13);
                    piVector8.copy(piVector4);
                    for (int i = 0; i < n13; ++i) {
                        if (piVector2.m_data[(i + n15 - 1 + n7) % n7] == -1) continue;
                        object = pgElementSet.getNeighbour(piVector2.m_data[(i + n15 - 1 + n7) % n7]);
                        n11 = pgElementSet.getOppVertexLocInd(n3, (i + n15 - 1 + n7) % n7);
                        if (n11 < 0) continue;
                        PiVector piVector9 = pgElementSet.getElement(piVector2.m_data[(i + n15 - 1 + n7) % n7]);
                        int n16 = piVector9.getSize();
                        if (!(piVector.m_data[(i + n15) % n7] == piVector9.m_data[(n11 + 1) % n16] && piVector.m_data[(i + n15 + 1) % n7] == piVector9.m_data[(n11 + 2) % n16] || piVector.m_data[(i + n15) % n7] == piVector9.m_data[(n11 + 2) % n16] && piVector.m_data[(i + n15 + 1) % n7] == piVector9.m_data[(n11 + 1) % n16])) {
                            for (n11 = 0; !(n11 >= n16 || piVector.m_data[(i + n15) % n7] == piVector9.m_data[(n11 + 1) % n16] && piVector.m_data[(i + n15 + 1) % n7] == piVector9.m_data[(n11 + 2) % n16] || piVector.m_data[(i + n15) % n7] == piVector9.m_data[(n11 + 2) % n16] && piVector.m_data[(i + n15 + 1) % n7] == piVector9.m_data[(n11 + 1) % n16]); ++n11) {
                            }
                        }
                        object.m_data[n11] = n4;
                    }
                }
                ++n4;
                piVector.setSize(n14);
                piVector.copy(piVector5);
                if (bl2) {
                    piVector2.setSize(n14);
                    piVector2.copy(piVector3);
                }
                n7 = n15 - n6;
            }
            if (n7 >= 3) continue;
            piVector.setTag(2);
        }
        if (!bl) {
            return;
        }
        if (bl2) {
            for (n3 = 0; n3 < n4; ++n3) {
                PiVector piVector10;
                if (!pgElementSet.hasTagElement(n3, 2) || (piVector = pgElementSet.getElement(n3)).getSize() != 2) continue;
                piVector2 = pgElementSet.getNeighbour(n3);
                if (piVector2.m_data[0] == -1) {
                    if (piVector2.m_data[1] == -1) continue;
                    piVector10 = pgElementSet.getNeighbour(piVector2.m_data[1]);
                    int n17 = pgElementSet.getOppVertexLocInd(n3, 1);
                    if (n17 <= -1) continue;
                    piVector10.m_data[n17] = -1;
                    continue;
                }
                if (piVector2.m_data[1] == -1) {
                    piVector10 = pgElementSet.getNeighbour(piVector2.m_data[0]);
                    int n18 = pgElementSet.getOppVertexLocInd(n3, 0);
                    if (n18 <= -1) continue;
                    piVector10.m_data[n18] = -1;
                    continue;
                }
                piVector10 = pgElementSet.getNeighbour(piVector2.m_data[0]);
                PiVector piVector11 = pgElementSet.getNeighbour(piVector2.m_data[1]);
                n2 = pgElementSet.getOppVertexLocInd(n3, 0);
                n = pgElementSet.getOppVertexLocInd(n3, 1);
                if (n2 > -1) {
                    piVector10.m_data[n2] = piVector2.m_data[1];
                }
                if (n <= -1) continue;
                piVector11.m_data[n] = piVector2.m_data[0];
            }
        }
        pgElementSet.setDimOfElements(-1);
        pgElementSet.removeMarkedElements();
        pgElementSet.assureDimOfElements();
        if (bl5) {
            pgElementSet.makeElementNormals();
        }
    }
}

