/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgUtil {
    public static PiVector[] triangulate(PdVector[] pdVectorArray, int n) {
        int n2;
        int n3;
        if (pdVectorArray == null) {
            PsDebug.warning("missing polygon");
            return null;
        }
        if (n < 3) {
            PsDebug.warning("numVertices < 3");
            return null;
        }
        PiVector[] piVectorArray = PiVector.realloc(null, n - 2, 3);
        PdVector[] pdVectorArray2 = new PdVector[n];
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3] = (n3 + 1) % n;
        }
        int n4 = -1;
        int n5 = n - 1;
        int n6 = 0;
        for (n2 = 0; n2 < n - 3; ++n2) {
            int n7 = n - n2;
            int n8 = n6;
            for (n3 = 0; n3 < n7; ++n3) {
                pdVectorArray2[n3] = pdVectorArray[n8];
                n8 = nArray[n8];
            }
            PdVector.angleWithOrientation(dArray, pdVectorArray2, n7);
            double d = Double.NEGATIVE_INFINITY;
            int n9 = -1;
            n8 = n6;
            for (n3 = 0; n3 < n7; ++n3) {
                if (dArray[n3] > d) {
                    d = dArray[n3];
                    n9 = n8;
                    n4 = n5;
                }
                n5 = n8;
                n8 = nArray[n8];
            }
            if (n9 == -1) {
                PsDebug.error("missing max angle", pdVectorArray);
                return null;
            }
            piVectorArray[n2].set(n4, n9, nArray[n9]);
            nArray[n4] = nArray[n9];
            n5 = n4;
            n6 = nArray[n9];
        }
        piVectorArray[n2].set(n6, nArray[n6], nArray[nArray[n6]]);
        return piVectorArray;
    }

    public static PiVector[] triangulate(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            return null;
        }
        return PgUtil.triangulate(pdVectorArray, pdVectorArray.length);
    }
}

