/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsList;

public class PgPointSet_VP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgPointSet m_pointSet;
    protected PgVectorField m_selectedVf;
    protected TextField m_tNumFields;
    protected PsPanel m_pVectorIP;
    protected CheckboxGroup m_gSelectionMode;
    protected Checkbox m_cSingle;
    protected Checkbox m_cMultiple;
    protected List m_listVisible;
    protected List m_listSelect;
    protected boolean m_bDeleteMode = false;
    private Color m_deleteColor;
    protected boolean m_bDuplicateMode = false;
    private Color m_duplicateColor;
    protected Button m_bNew;
    protected Button m_bDuplicate;
    protected Button m_bDelete;
    protected Button m_bDeleteHidden;
    static /* synthetic */ Class class$jv$geom$PgPointSet_VP;

    public PgPointSet_VP() {
        if (this.getClass() == (class$jv$geom$PgPointSet_VP == null ? (class$jv$geom$PgPointSet_VP = PgPointSet_VP.class$("jv.geom.PgPointSet_VP")) : class$jv$geom$PgPointSet_VP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        this.addTitle("");
        Panel panel = new Panel(new GridLayout(1, 2));
        this.add(panel);
        Component component = new Label(PsConfig.getMessage(24063));
        panel.add(component);
        this.m_tNumFields = new TextField("0", 7);
        this.m_tNumFields.addActionListener(this);
        panel.add(this.m_tNumFields);
        this.m_pVectorIP = new PsPanel();
        this.add(this.m_pVectorIP);
        this.addLine(1);
        component = new PsPanel();
        ((PsPanel)component).setInsetSize(3);
        this.add(component);
        Panel panel2 = new PsPanel(new GridLayout(1, 2));
        ((PsPanel)panel2).addSubTitle(PsConfig.getMessage(24065));
        Panel panel3 = new Panel(new GridLayout(1, 2));
        this.m_gSelectionMode = new CheckboxGroup();
        this.m_cSingle = new Checkbox(PsConfig.getMessage(24066), this.m_gSelectionMode, false);
        this.m_cSingle.addItemListener(this);
        panel3.add(this.m_cSingle);
        this.m_cMultiple = new Checkbox(PsConfig.getMessage(24067), this.m_gSelectionMode, true);
        this.m_cMultiple.addItemListener(this);
        panel3.add(this.m_cMultiple);
        panel2.add(panel3);
        ((Container)component).add(panel2);
        panel3 = new Panel(new GridLayout(1, 2));
        Panel panel4 = new Panel(new BorderLayout());
        Label label = new Label(PsConfig.getMessage(24068));
        panel4.add((Component)label, "North");
        this.m_listSelect = new List(7, false);
        this.m_listSelect.addItemListener(this);
        panel4.add((Component)this.m_listSelect, "Center");
        panel3.add(panel4);
        Panel panel5 = new Panel(new BorderLayout());
        Label label2 = new Label(PsConfig.getMessage(24065));
        panel5.add((Component)label2, "North");
        this.m_listVisible = new PsList(7, true);
        this.m_listVisible.addItemListener(this);
        panel5.add((Component)this.m_listVisible, "Center");
        panel3.add(panel5);
        ((Container)component).add(panel3);
        panel2 = new Panel(new FlowLayout());
        this.add(panel2);
        this.m_bNew = new Button(PsConfig.getMessage(24069));
        this.m_bNew.addActionListener(this);
        panel2.add(this.m_bNew);
        this.m_bDuplicate = new Button(PsConfig.getMessage(24070));
        this.m_bDuplicate.addActionListener(this);
        panel2.add(this.m_bDuplicate);
        this.m_bDelete = new Button(PsConfig.getMessage(24071));
        this.m_bDelete.addActionListener(this);
        panel2.add(this.m_bDelete);
        this.m_bDeleteHidden = new Button(PsConfig.getMessage(24072));
        this.m_bDeleteHidden.addActionListener(this);
        panel2.add(this.m_bDeleteHidden);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_pointSet = (PgPointSet)psUpdateIf;
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_pointSet == null) {
            PsDebug.warning("missing elementSet");
            return true;
        }
        if (object == this.m_pointSet) {
            String string;
            int n;
            this.setTitle(PsConfig.getMessage(24073) + ": " + this.m_pointSet.getName());
            PgVectorField[] pgVectorFieldArray = this.m_pointSet.getVectorFields();
            PsPanel.setText(this.m_tNumFields, String.valueOf(this.m_pointSet.getNumVectorFields()));
            PgVectorField pgVectorField = this.m_pointSet.getSelectedVectorField();
            if (pgVectorField != this.m_selectedVf) {
                this.m_pVectorIP.removeAll();
                this.m_selectedVf = pgVectorField;
                if (this.m_selectedVf != null) {
                    this.m_pVectorIP.addLine(1);
                    this.m_pVectorIP.add(this.m_selectedVf.getInfoPanel());
                }
                this.validate();
            }
            if (this.m_pointSet.isShowingSingleVectorField()) {
                PsPanel.setSelectedCheckbox(this.m_gSelectionMode, this.m_cSingle);
            } else {
                PsPanel.setSelectedCheckbox(this.m_gSelectionMode, this.m_cMultiple);
            }
            boolean bl = true;
            int n2 = this.m_pointSet.getNumVectorFields();
            int n3 = this.m_listVisible.getItemCount();
            if (n3 != n2) {
                bl = false;
            } else {
                for (n = 0; n < n2; ++n) {
                    string = this.m_listVisible.getItem(n);
                    if (string != null && string.equals(pgVectorFieldArray[n].getName())) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                if (n3 > 0) {
                    this.m_listVisible.removeAll();
                    this.m_listSelect.removeAll();
                }
                for (n = 0; n < n2; ++n) {
                    string = pgVectorFieldArray[n].getName();
                    this.m_listVisible.add(string);
                    this.m_listSelect.add(string);
                }
            }
            for (n = 0; n < n2; ++n) {
                if (pgVectorFieldArray[n].isVisible() != this.m_listVisible.isIndexSelected(n)) {
                    if (pgVectorFieldArray[n].isVisible()) {
                        this.m_listVisible.select(n);
                    } else {
                        this.m_listVisible.deselect(n);
                    }
                }
                if (pgVectorFieldArray[n] != this.m_selectedVf) continue;
                this.m_listSelect.select(n);
            }
            return true;
        }
        return super.update(object);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        PsDebug.notify("entered");
        if (object == this.m_listVisible) {
            int n = (Integer)itemEvent.getItem();
            PsDebug.notify("selected index = " + n + " in listVisible");
            if (n < 0 || this.m_listVisible.getItemCount() <= n) {
                return;
            }
            PgVectorField[] pgVectorFieldArray = this.m_pointSet.getVectorFields();
            if (this.m_bDeleteMode) {
                this.deleteGeom(pgVectorFieldArray[n]);
            } else if (this.m_bDuplicateMode) {
                this.duplicateGeom(pgVectorFieldArray[n]);
            } else {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        PsDebug.notify("show vector field = " + pgVectorFieldArray[n].getName());
                        if (this.m_pointSet.isShowingSingleVectorField()) {
                            this.m_pointSet.selectVectorField(pgVectorFieldArray[n]);
                        }
                        pgVectorFieldArray[n].setVisible(true);
                        break;
                    }
                    case 2: {
                        PsDebug.notify("hide vector field = " + pgVectorFieldArray[n].getName());
                        pgVectorFieldArray[n].setVisible(false);
                    }
                }
                pgVectorFieldArray[n].update(pgVectorFieldArray[n]);
            }
        } else if (object == this.m_listSelect) {
            int n = (Integer)itemEvent.getItem();
            PsDebug.notify("selected index = " + n + " in listSelect");
            if (n < 0 || this.m_listSelect.getItemCount() <= n) {
                return;
            }
            PgVectorField[] pgVectorFieldArray = this.m_pointSet.getVectorFields();
            if (this.m_bDeleteMode) {
                this.deleteGeom(pgVectorFieldArray[n]);
            } else if (this.m_bDuplicateMode) {
                this.duplicateGeom(pgVectorFieldArray[n]);
            } else {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        PsDebug.notify("select vector field = " + pgVectorFieldArray[n].getName());
                        this.m_pointSet.selectVectorField(pgVectorFieldArray[n]);
                        this.m_pointSet.update(pgVectorFieldArray[n]);
                    }
                }
            }
        } else {
            if (object == this.m_cSingle) {
                if (this.m_pointSet.isShowingSingleVectorField()) {
                    return;
                }
                this.m_pointSet.showSingleVectorField(true);
                this.m_pointSet.update(this.m_pointSet);
                return;
            }
            if (object == this.m_cMultiple) {
                if (!this.m_pointSet.isShowingSingleVectorField()) {
                    return;
                }
                this.m_pointSet.showSingleVectorField(false);
                this.m_pointSet.update(this);
            } else {
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PsDebug.notify("entered");
        if (this.m_pointSet == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tNumFields) {
            try {
                int n = Integer.parseInt(this.m_tNumFields.getText());
                if (n == this.m_pointSet.getNumVectorFields()) {
                    return;
                }
                if (n > this.m_pointSet.getNumVectorFields()) {
                    PsPanel.setText(this.m_tNumFields, String.valueOf(this.m_pointSet.getNumVectorFields()));
                    return;
                }
                PsDebug.notify("setNumVectors=" + this.m_tNumFields.getText());
                for (int i = this.m_pointSet.getNumVectorFields() - 1; i >= n; --i) {
                    this.m_pointSet.removeVectorField(this.m_pointSet.getVectorField(i));
                }
                this.m_pointSet.update(this.m_pointSet);
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format = " + this.m_tNumFields.getText(), this);
                return;
            }
        } else if (object == this.m_bNew) {
            PsDebug.notify("new");
            PgVectorField pgVectorField = new PgVectorField(this.m_pointSet.getDimOfVertices());
            pgVectorField.setName(PsConfig.getMessage(15006) + "[" + PsObject.getNumObjects() + "]");
            pgVectorField.setGeometry(this.m_pointSet);
            pgVectorField.setBasedOn(0);
            this.m_pointSet.addVectorField(pgVectorField);
            this.m_pointSet.update(this.m_pointSet);
        } else if (object == this.m_bDuplicate) {
            PsDebug.notify("duplicate");
            if (this.m_bDuplicateMode) {
                this.m_bDuplicateMode = false;
                this.m_bDuplicate.setBackground(this.m_duplicateColor);
                this.m_bDuplicate.setLabel(PsConfig.getMessage(24070));
            } else {
                this.m_bDuplicateMode = true;
                this.m_duplicateColor = this.m_bDuplicate.getBackground();
                this.m_bDuplicate.setBackground(Color.red);
                this.m_bDuplicate.setLabel(PsConfig.getMessage(24074));
            }
        } else if (object == this.m_bDelete) {
            PsDebug.notify("delete");
            if (this.m_bDeleteMode) {
                this.m_bDeleteMode = false;
                this.m_bDelete.setBackground(this.m_deleteColor);
                this.m_bDelete.setLabel(PsConfig.getMessage(24071));
            } else {
                this.m_bDeleteMode = true;
                this.m_deleteColor = this.m_bDelete.getBackground();
                this.m_bDelete.setBackground(Color.red);
                this.m_bDelete.setLabel(PsConfig.getMessage(24074));
            }
        } else if (object == this.m_bDeleteHidden) {
            this.m_pointSet.removeHiddenVectorFields();
            this.m_pointSet.update(this.m_pointSet);
        }
    }

    private void deleteGeom(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            return;
        }
        PsDebug.notify("deleting vector field = " + pgVectorField.getName());
        this.m_pointSet.removeVectorField(pgVectorField);
        this.m_pointSet.update(this.m_pointSet);
        this.m_bDeleteMode = false;
        this.m_bDelete.setBackground(this.m_deleteColor);
        this.m_bDelete.setLabel(PsConfig.getMessage(24071));
    }

    private void duplicateGeom(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            return;
        }
        PsDebug.notify("duplicating vector field = " + pgVectorField.getName());
        PgVectorField pgVectorField2 = (PgVectorField)pgVectorField.clone();
        pgVectorField2.setName(PsConfig.getMessage(15007) + PsObject.getNumObjects() + "-" + pgVectorField.getName());
        this.m_pointSet.addVectorField(pgVectorField2);
        this.m_pointSet.selectVectorField(pgVectorField2);
        this.m_pointSet.update(this.m_pointSet);
        this.m_bDuplicateMode = false;
        this.m_bDuplicate.setBackground(this.m_duplicateColor);
        this.m_bDuplicate.setLabel(PsConfig.getMessage(24070));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

