/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.stats;

import org.ddogleg.stats.UtilGaussian;
import org.junit.Assert;
import org.junit.Test;

public class TestUtilGaussian {
    @Test
    public void computePDF() {
        double max = UtilGaussian.computePDF(2.0, 1.5, 2.0);
        Assert.assertTrue((UtilGaussian.computePDF(2.0, 1.5, 1.0) < max ? 1 : 0) != 0);
        Assert.assertTrue((UtilGaussian.computePDF(2.0, 1.5, 3.0) < max ? 1 : 0) != 0);
        Assert.assertEquals((double)UtilGaussian.computePDF(2.0, 1.5, 1.0), (double)UtilGaussian.computePDF(2.0, 1.5, 3.0), (double)1.0E-8);
        Assert.assertTrue((UtilGaussian.computePDF(2.0, 2.0, 2.0) < max ? 1 : 0) != 0);
        Assert.assertTrue((UtilGaussian.computePDF(2.0, 1.0, 2.0) > max ? 1 : 0) != 0);
    }

    @Test
    public void derivative1() {
        double expected = TestUtilGaussian.deriv1(1.5, 2.0, 1.8);
        Assert.assertEquals((double)expected, (double)UtilGaussian.derivative1(1.5, 2.0, 1.8), (double)1.0E-4);
    }

    @Test
    public void derivative2() {
        double expected = TestUtilGaussian.deriv2(1.5, 2.0, 1.8);
        Assert.assertEquals((double)expected, (double)UtilGaussian.derivative2(1.5, 2.0, 1.8), (double)0.001);
    }

    @Test
    public void derivative3() {
        double expected = TestUtilGaussian.deriv3(1.5, 2.0, 1.8);
        Assert.assertEquals((double)expected, (double)UtilGaussian.derivative3(1.5, 2.0, 1.8), (double)0.001);
    }

    @Test
    public void derivative4() {
        double expected = TestUtilGaussian.deriv4(1.5, 2.0, 1.8);
        Assert.assertEquals((double)expected, (double)UtilGaussian.derivative4(1.5, 2.0, 1.8), (double)0.1);
    }

    public static double normal(double mu, double sigma, double x) {
        double delta = x - mu;
        double a = -delta * delta / (2.0 * sigma * sigma);
        double b = Math.PI * 2 * sigma * sigma;
        return 1.0 / Math.sqrt(b) * Math.exp(a);
    }

    public static double deriv1(double mu, double sigma, double x) {
        return (TestUtilGaussian.normal(mu, sigma, x + 1.0E-10) - TestUtilGaussian.normal(mu, sigma, x)) / 1.0E-10;
    }

    public static double deriv2(double mu, double sigma, double x) {
        return (TestUtilGaussian.deriv1(mu, sigma, x + 0.001) - TestUtilGaussian.deriv1(mu, sigma, x - 0.001)) / 0.002;
    }

    public static double deriv3(double mu, double sigma, double x) {
        double d = 0.1;
        return (TestUtilGaussian.deriv2(mu, sigma, x + d) - TestUtilGaussian.deriv2(mu, sigma, x - d)) / (2.0 * d);
    }

    public static double deriv4(double mu, double sigma, double x) {
        double d = 0.1;
        return (TestUtilGaussian.deriv3(mu, sigma, x + d) - TestUtilGaussian.deriv3(mu, sigma, x - d)) / (2.0 * d);
    }
}

