/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.QuickSort_F32;
import org.ddogleg.util.UtilDouble;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSort_F32 {
    Random rand = new Random(1044180L);

    @Test
    public void testSortingRandom() {
        float[] ret = TestQuickSort_F32.createRandom(this.rand, 200);
        float preTotal = UtilDouble.sum(ret);
        QuickSort_F32 sorter = new QuickSort_F32();
        sorter.sort(ret, ret.length);
        float postTotal = UtilDouble.sum(ret);
        Assert.assertEquals((double)preTotal, (double)postTotal, (double)0.01);
        float prev = ret[0];
        for (int i = 1; i < ret.length; ++i) {
            if (ret[i] < prev) {
                Assert.fail((String)"Not ascending");
            }
            prev = ret[i];
        }
    }

    @Test
    public void testSortingRandom_indexes() {
        for (int a = 0; a < 20; ++a) {
            float[] normal = TestQuickSort_F32.createRandom(this.rand, 20);
            float[] original = (float[])normal.clone();
            float[] withIndexes = (float[])normal.clone();
            int[] indexes = new int[normal.length];
            QuickSort_F32 sorter = new QuickSort_F32();
            sorter.sort(normal, normal.length);
            sorter.sort(withIndexes, normal.length, indexes);
            for (int i = 0; i < normal.length; ++i) {
                Assert.assertEquals((double)original[i], (double)withIndexes[i], (double)1.0E-4);
                Assert.assertEquals((double)normal[i], (double)withIndexes[indexes[i]], (double)1.0E-4);
            }
        }
    }

    public static float[] createRandom(Random rand, int num) {
        float[] ret = new float[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (rand.nextFloat() - 0.5f) * 2000.0f;
        }
        return ret;
    }
}

